package com.digiwin.athena.bo.assembly;

import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.Data;

/**
 * 运行时变量响应DTO
 */
@Data
public class RuntimeVariable {

    /**
     * 系统变量
     */
    private Sys sys;
    /**
     * 会话变量，保存前端传递变量
     */
    private Context context;

    public static RuntimeVariable capture() {
        RuntimeVariable runtimeVariable = new RuntimeVariable();
        runtimeVariable.setContext(Context.capture());

        return runtimeVariable;
    }


    @Data
    public static class User {
        private String id;
        private String name;
        private String token;
        private String tenantId;
        private String tenantSid;
        private String tenantName;
        private String teamId;

        public static User capture() {
            UserPO userPo = UserHelper.getCurrentUser();
            // 获取租户信息
            TenantInfo tenantInfo = CurThreadInfoUtils.getCurTokenTenant();

            // 构建sys.userPo
            RuntimeVariable.User userVar = new RuntimeVariable.User();
//            userVar.setId(StrUtil.toStringOrNull(userPo.getId()));
            userVar.setName(userPo.getName());
            userVar.setToken(UserHelper.getCurrentIamToken());

            if (tenantInfo != null) {
                userVar.setTenantId(tenantInfo.getTenantId());
                userVar.setTenantSid(tenantInfo.getTenantSid());
                userVar.setTenantName(tenantInfo.getTenantName());
//                userVar.setTeamId(tenantInfo.getTeamId());
            }

            return userVar;
        }
    }


    @Data
    public static class Sys {
        private String appToken;
        private String integrationToken;

        public static Sys capture() {
            Sys sys = new RuntimeVariable.Sys();
            // TODO pzz 待定

            return sys;
        }
    }

    /**
     * 会话变量，由前端传递过来
     */
    @Data
    public static class Context {
        private User user;

        private String branch;
        private String locale;
        private String application;
        private String tenantProcessId;
        private String individualCaseAppCode;
        private String platformSource;
        private String routerKey;
        private String templateId;

        public static Context capture() {
            Context context = new Context();

            context.setUser(User.capture());
            context.setBranch(CurThreadInfoUtils.getBranchKey());
            context.setLocale(CurThreadInfoUtils.getLocale());
            context.setApplication(CurThreadInfoUtils.getCurApplication());
            context.setIndividualCaseAppCode(CurThreadInfoUtils.getIndividualCaseAppCode());
            context.setPlatformSource(CurThreadInfoUtils.getPlatformSource());
            context.setRouterKey(CurThreadInfoUtils.getRouterKey());
            context.setTemplateId(CurThreadInfoUtils.getTemplateId());
//            env.setTenantProcessId(CurThreadInfoUtils.getTenantProcessId());

            return context;
        }

    }
}
