package com.digiwin.athena.dto.assembly.variable;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 设计器变量树节点DTO
 */
@Data
public class VarDefMapNode {
    /**
     * 节点标签
     */
    private String label;

    /**
     * 节点值
     */
    private String value;

    /**
     * 节点类型：'string' | 'number' | 'boolean' | 'object' | 'datetime'
     */
    private String type;

    /**
     * 变量引用计算表达式，会将当前的{@link #valEvalExpr}、{@link #children}设置为引用变量的值
     */
    private String reference;

    /**
     * 表达式字符串
     */
    private String valEvalExpr;

    /**
     * 表达式计算结果
     */
    private Object valEvalRet;

    /**
     * 实际为运行时取值变量名。
     * 全路径，前端运行时取值使用
     */
    private String fullPath;

    /**
     * 子节点列表
     */
    private Map<String, VarDefMapNode> children;


    /**
     * @return 运行时变量map，扁平化结构。sys->user->id在map中key为"sys.user.id"
     */
    public Map<String, Object> toMap() {

        Map<String,Object> childrenMap = new HashMap<>();
        children.forEach((k, v) -> childrenMap.putAll(v.toMap()));

        Map<String, Object> map = new HashMap<>();

        map.put(getVarName(), childrenMap);
        return map;
    }


    public String getVarName() {
        return value;
    }

    public void putReference(VarDefMapNode referenceNode) {
        setValEvalExpr(referenceNode.getValEvalExpr());
        setChildren(referenceNode.getChildren());
    }
}
