package com.digiwin.athena.dto.assetType;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.constants.AssemblyConstants;
import com.digiwin.athena.constants.AssemblyErrorCode;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.mongodb.domain.ApiInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AssetTypeReqDto {

    private String objId;

    @Schema(description = "资产类型")
    @Size(max = 30, message = "长度不能超过30")
    @Pattern(regexp = AssemblyConstants.TYPE_PATTERN_STR, message = AssemblyConstants.TYPE_PATTERN_TIP)
    private String type;
    @Schema(description = "资产名称")
    @Size(max = 50, message = "长度不能超过50")
    private String name;
    @Schema(description = "资产版本")
    private String version;
    @Schema(description = "资产大类")
    private String category;
    @Schema(description = "资产归属")
    private String owner;
//    @Schema(description = "状态|草稿draft、已上架online、已下架offline")
//    private String status= AssetType.STATUS_DRAFT;
    @Schema(description = "描述")
    @Size(max = 512, message = "长度不能超过512")
    private String description;
    @Schema(description = "用户手册")
    private String docUrl;
    @Schema(description = "资产操作api")
    private List<ApiInfo> apiList;
    @Schema(description = "OpenApi")
    private List<ApiInfo> openApiList;

    @Schema(description = "元数据信息")
    private JSONObject metadata;
    @Schema(description = "依赖定义")
    private List<JSONObject> dependencyRule;
    @Schema(description = "管理上下文定义")
    private List<JSONObject> manageContextRule;
    @Schema(description = "数据收集配置")
    private JSONObject dataCollectConfig;
    private JSONObject rowDataPermission;
    private Map<String, MultiLanguageDTO> lang;

    private String icon;

    /**
     * 能否引用
     */
    private Boolean canReference = false;
    /**
     * 能否复制
     */
    private Boolean canCopy = false;

    /**
     * 校验type字段格式
     *
     * @throws BusinessException 如果type字段格式不符合要求
     */
    public void validateTypeFormat() {
        if (StrUtil.isBlank(type)) {
            throw new BusinessException(AssemblyErrorCode.INVALID_PARAM, "资产类型编码不能为空！");
        }

        if (!AssemblyConstants.TYPE_PATTERN.matcher(type).matches()) {
            throw new BusinessException(AssemblyErrorCode.INVALID_PARAM,
                    StrUtil.format("资产类型编码格式不正确！{}，当前编码: {}", AssemblyConstants.TYPE_PATTERN_TIP, type));
        }
    }
}
