package com.digiwin.athena.service.assembly;

import com.digiwin.athena.bo.assembly.RuntimeVariable;
import com.digiwin.athena.dto.assembly.variable.VarDefMapNode;

import java.util.Map;

/**
 * 设计器运行时变量查询服务接口
 */
public interface RVariableService {

    /**
     * 查询运行时变量
     *
     * @return 运行时变量，包含sys用户和环境信息
     */
    RuntimeVariable getRuntimeVar();

    /**
     *
     * @param key 变量组key
     * @return 运行时变量map，扁平化结构。sys->user->id在map中key为"sys.user.id"
     * @see VarDefMapNode#toMap()
     */
    Map<String, Object> getRuntimeVarMap(String key);
}
