package com.digiwin.athena.service.assembly.impl;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.service.assembly.RDesignerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 运行时Designer列表服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RDesignerServiceImpl implements RDesignerService {

    private final RDesignerMongoDao rDesignerMongoDao;

    @Override
    public Pagination<DesignerListDTO> getOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageParam) {
        log.debug("分页查询在线状态的设计器列表");
        // TODO pzz 查询运行时资产、解决方案的最新名称及type
        return rDesignerMongoDao.selectOnlineDesignerPage(pageParam);
    }

    @Override
    public List<Designer> getDesigners(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return new ArrayList<>();
        }
        return rDesignerMongoDao.selectByIds(ids);
    }
}
