/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.convertor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.common.dict.Dict;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.mapstruct.Mapper;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public class BaseConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseConverter.class);
    public static BaseConverter INSTANCE = (BaseConverter)Mappers.getMapper(BaseConverter.class);
    protected static ObjectMapper objectMapper;

    public Integer toInt(String category) {
        if (StrUtil.isBlank((CharSequence)category)) {
            return null;
        }
        return Integer.parseInt(category);
    }

    public LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTimeUtil.of((Date)date);
    }

    public Date localDateTime2Date(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return DateUtil.date((TemporalAccessor)localDateTime);
    }

    @Named(value="shallowMap")
    public <K, V> Map<K, V> shallowMap(Map<K, V> map) {
        return map;
    }

    @Named(value="shallowColl")
    public <V> Collection<V> directList(Collection<V> obj) {
        return obj;
    }

    @Named(value="jsonSerialize")
    public String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.warn("json\u5e8f\u5217\u5316\u5f02\u5e38\uff01msg:{}", (Object)e.getMessage());
            return null;
        }
    }

    public <T> List<T> deserializeList(String jsonStr, Class<T> clazz) {
        return (List)this.deserialize(jsonStr, List.class, clazz);
    }

    public <K, T> Map<K, T> deserializeMap(String jsonStr, Class<K> keyClazz, Class<T> clazz) {
        return (Map)this.deserialize(jsonStr, Map.class, keyClazz, clazz);
    }

    public <T> T deserialize(String jsonStr, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonStr, clazz);
        }
        catch (JsonProcessingException e) {
            log.warn("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01msg:{}", (Object)e.getMessage());
            return null;
        }
    }

    public <T> T deserialize(String json, Class<?> clazz, Class<?> ... genericClass) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazz, (Class[])genericClass);
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    public <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        return BeanUtil.copyToList(collection, targetType, (CopyOptions)CopyOptions.create());
    }

    public void translateDictField(Object obj) {
        try {
            Dict.Translator.translate(obj);
        }
        catch (Exception e) {
            log.error("\u7ffb\u8bd1\u5b57\u5178\u503c\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        BaseConverter.objectMapper = objectMapper;
    }
}

