/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.expression;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class ExpressionResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpressionResolver.class);
    public static final String EXPRESSION_PREFIX = "{{ ";
    public static final String EXPRESSION_SUFFIX = " }}";
    private static final String EXAMPLE = "{{ varName }}";
    protected final TemplateParserContext templateParserContext = new TemplateParserContext("{{ ", " }}");
    protected StandardEvaluationContext context;
    protected ExpressionParser parser;

    public String resolveToStr(String text, Object contextObj) {
        return StrUtil.toStringOrNull((Object)this.resolveStr(text, contextObj));
    }

    public Object resolveStr(String text, Object contextObj) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        try {
            Expression exp = this.getParser().parseExpression(text, (ParserContext)this.templateParserContext);
            Object value = exp.getValue((EvaluationContext)this.context, contextObj);
            return value != null ? value : text;
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u89e3\u6790\u8868\u8fbe\u5f0f: {}, \u4fdd\u6301\u539f\u503c,msg:{}", (Object)text, (Object)e.getMessage());
            return text;
        }
    }

    public Map<String, Object> resolveMap(Map<String, Object> obj, Object contextObj, String ... expressionKeys) {
        return this.resolve(obj, contextObj, null, expressionKeys);
    }

    public <T> List<T> resolveList(List<T> obj, Object contextObj, String ... expressionKeys) {
        return this.resolve(obj, contextObj, null, expressionKeys);
    }

    public <T> T resolve(T obj, Object contextObj, BeanAccessor<T> beanAccessor, String ... expressionKeys) {
        Resolver<T> resolver = new Resolver<T>((Map)Convert.convert(Map.class, (Object)contextObj), beanAccessor, CollUtil.newHashSet((Object[])expressionKeys));
        return resolver.resolve(obj);
    }

    public String wrapVarName(String varName) {
        if (varName == null) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)(varName = StrUtil.trim((CharSequence)varName)))) {
            return varName;
        }
        return EXPRESSION_PREFIX + varName + EXPRESSION_SUFFIX;
    }

    protected ExpressionParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        this.context = new StandardEvaluationContext();
        this.context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.MIXED, null, false, false, Integer.MAX_VALUE);
        this.parser = new SpelExpressionParser(config);
        return this.parser;
    }

    public static class BeanAccessor<T> {
        protected final List<FieldAccessor<T>> fieldAccessors = new ArrayList<FieldAccessor<T>>();

        public static <T> BeanAccessor<T> create() {
            return new BeanAccessor<T>();
        }

        public boolean accept(Object obj) {
            return this.fieldAccessors.stream().anyMatch(v -> v.accept(obj));
        }

        public <R> BeanAccessor<T> addMapping(Class<T> entityClass, Function<T, String> getter, BiConsumer<T, R> setter) {
            return this.addMapping(entityClass, getter, setter, null);
        }

        public <R> BeanAccessor<T> addMapping(Class<T> entityClass, Function<T, String> getter, BiConsumer<T, R> setter, Function<T, Object> childrenGetter) {
            this.fieldAccessors.add(new FieldAccessor<Object>(entityClass, getter, (obj, value) -> setter.accept(obj, value), childrenGetter));
            return this;
        }

        public static class FieldAccessor<T> {
            protected final Function<T, String> expressionGetter;
            protected final BiConsumer<T, Object> resultSetter;
            protected final Function<T, Object> childrenGetter;
            protected final Class<T> entityClass;

            FieldAccessor(Class<T> entityClass, Function<T, String> expressionGetter, BiConsumer<T, Object> resultSetter, Function<T, Object> childrenGetter) {
                this.expressionGetter = expressionGetter;
                this.resultSetter = resultSetter;
                this.childrenGetter = childrenGetter;
                this.entityClass = entityClass;
            }

            public boolean accept(Object obj) {
                return this.entityClass.isAssignableFrom(obj.getClass());
            }

            public String getExpression(T obj) {
                return this.expressionGetter != null ? this.expressionGetter.apply(obj) : null;
            }

            public void consumeResult(T obj, Object value) {
                if (this.resultSetter != null) {
                    this.resultSetter.accept(obj, value);
                }
            }

            public Object getChildren(T obj) {
                return this.childrenGetter != null ? this.childrenGetter.apply(obj) : null;
            }

            @Generated
            public Function<T, String> getExpressionGetter() {
                return this.expressionGetter;
            }

            @Generated
            public BiConsumer<T, Object> getResultSetter() {
                return this.resultSetter;
            }

            @Generated
            public Function<T, Object> getChildrenGetter() {
                return this.childrenGetter;
            }

            @Generated
            public Class<T> getEntityClass() {
                return this.entityClass;
            }
        }
    }

    public class Resolver<T> {
        protected final Map<String, Object> contextObj;
        protected final BeanAccessor<T> beanAccessor;
        protected final Set<String> expressionKeys;

        public Resolver(Map<String, Object> contextObj, BeanAccessor<T> beanAccessor, Set<String> expressionKeys) {
            this.contextObj = contextObj;
            this.beanAccessor = beanAccessor;
            this.expressionKeys = expressionKeys;
        }

        public Map<String, Object> resolveMap(Map<String, Object> map) {
            if (map == null || map.isEmpty()) {
                return map;
            }
            return (Map)map.entrySet().stream().filter(entry -> this.expressionKeys.contains(entry.getKey()) || CollUtil.isEmpty(this.expressionKeys)).collect(CollectorUtil.toMap(Map.Entry::getKey, entry -> this.resolve(map, entry.getValue()), (v1, v2) -> v1));
        }

        public List<T> resolveList(List<T> list) {
            if (list == null || list.isEmpty()) {
                return list;
            }
            return list.stream().map(value -> this.resolve(list, value)).map(v -> v).collect(Collectors.toList());
        }

        public T resolve(T t) {
            if (t == null) {
                return null;
            }
            this.resolve(null, t);
            return t;
        }

        protected Object resolve(Object bean, Object value) {
            Object result;
            if (value instanceof String) {
                result = ExpressionResolver.this.resolveStr((String)value, this.contextObj);
            } else if (value instanceof Map) {
                Map nestedMap = (Map)value;
                result = this.resolveMap(nestedMap);
            } else {
                result = value instanceof List ? this.resolveList((List)value) : value;
            }
            if (this.beanAccessor != null) {
                this.beanAccessor.fieldAccessors.forEach(fieldAccessor -> {
                    Object children;
                    if (!fieldAccessor.accept(value)) {
                        return;
                    }
                    String expression = fieldAccessor.getExpression(value);
                    if (expression != null) {
                        fieldAccessor.consumeResult(value, this.resolve(value, expression));
                    }
                    if ((children = fieldAccessor.getChildren(value)) != null) {
                        this.resolve(bean, children);
                    }
                });
            }
            return result;
        }
    }
}

