/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.datacollect.expression.ExpressionResolver;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.DVariableService;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.assembly.RVariableService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RSolutionPlanServiceImpl
implements RSolutionPlanService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSolutionPlanServiceImpl.class);
    private final RSolutionMongoDao rSolutionMongoDao;
    private final DVariableService variableService;
    private final RVariableService rVariableService;
    private final ExpressionResolver expressionResolver;

    @Override
    public Pagination<SolutionPlanListDTO> list(PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        return this.rSolutionMongoDao.selectOnlineSolutionPage(pageReqCondition);
    }

    @Override
    public List<SolutionPlanListDTO> findByAppTypeOrAll(List<Integer> appType) {
        return this.rSolutionMongoDao.selectByAppType(new HashSet<Integer>(appType));
    }

    @Override
    public String resolveSsoUrl(SolutionPlanDetailDTO.SsoConfigDTO ssoConfig) {
        if (ssoConfig == null) {
            return null;
        }
        Map<String, Object> contextMap = this.rVariableService.getRuntimeVarMap("SolutionPlan_Sso");
        String url = this.expressionResolver.resolveToStr(ssoConfig.getUrl(), contextMap);
        Map<String, Object> paramMap = ssoConfig.toParamMap();
        paramMap.entrySet().stream().filter(v -> "value".equals(v.getKey())).forEach(entry -> entry.setValue(this.expressionResolver.wrapVarName(StrUtil.toStringOrNull(entry.getValue()))));
        Map<String, Object> resolvedMap = this.expressionResolver.resolveMap(paramMap, contextMap, "value");
        UrlBuilder urlBuilder = UrlBuilder.of((String)url);
        resolvedMap.forEach((arg_0, arg_1) -> ((UrlBuilder)urlBuilder).addQuery(arg_0, arg_1));
        return urlBuilder.build();
    }

    @Override
    public SolutionPlan findByAppType(Integer appType) {
        return this.rSolutionMongoDao.selectByAppType(appType);
    }

    @Generated
    public RSolutionPlanServiceImpl(RSolutionMongoDao rSolutionMongoDao, DVariableService variableService, RVariableService rVariableService, ExpressionResolver expressionResolver) {
        this.rSolutionMongoDao = rSolutionMongoDao;
        this.variableService = variableService;
        this.rVariableService = rVariableService;
        this.expressionResolver = expressionResolver;
    }
}

