/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.convertor.assembly.VariableConverter;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.variable.VarDefNode;
import com.digiwin.athena.dto.assembly.variable.VarTreeNodeDTO;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assembly.DVariableService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assembly/variable/d/"})
@Validated
public class DVariableController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DVariableController.class);
    private final DVariableService variableService;
    private final ManageBackgroundUserService manageBackgroundUserService;

    @GetMapping(value={"/tree"})
    public ResultDto<List<VarTreeNodeDTO>> queryVariableTree(@RequestParam(required=false) List<String> keys) {
        if (!this.manageBackgroundUserService.isManager().booleanValue()) {
            throw new BusinessException(Integer.valueOf(4006), new Object[0]);
        }
        log.debug("\u6536\u5230\u67e5\u8be2\u8bbe\u8ba1\u5668\u53d8\u91cf\u6811\u8bf7\u6c42\uff0ckeys: {}", keys);
        List<VarDefNode> result = this.variableService.queryVariableTree(keys);
        return ResultDto.createSuccess(VariableConverter.INSTANCE.toDto(result));
    }

    @Generated
    public DVariableController(DVariableService variableService, ManageBackgroundUserService manageBackgroundUserService) {
        this.variableService = variableService;
        this.manageBackgroundUserService = manageBackgroundUserService;
    }
}

