/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao.mongodao.assembly.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.convertor.assembly.DesignerConvertor;
import com.digiwin.athena.dao.mongodao.assembly.DDesignerMongoDao;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.mongodb.domain.assembly.DesignerEntity;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RDesignerMongoDaoImpl
implements RDesignerMongoDao {
    private final MongoRuntimeRepositoryDecorator decorator;

    @Override
    public Designer selectById(String objectId) {
        return DesignerConvertor.INSTANCE.toBO((DesignerEntity)this.decorator.findById((Object)objectId, DesignerEntity.class));
    }

    @Override
    public Pagination<DesignerListDTO> selectOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageParam) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)OnlineState.Online.getCode()));
        RDesignerPageQo condition = (RDesignerPageQo)ObjectUtil.defaultIfNull((Object)((RDesignerPageQo)pageParam.getCondition()), RDesignerPageQo::new);
        DDesignerMongoDao.addSearchNameOrType(query, condition.getSearchContent());
        return this.decorator.findWithPage(query, DesignerEntity.class, pageParam).convert(DesignerConvertor.INSTANCE::toListDTO);
    }

    @Override
    public void save(Designer designer) {
        DesignerEntity entity = DesignerConvertor.INSTANCE.toPo(designer);
        entity.prepareSave();
        this.decorator.save((Object)entity);
        designer.setId(entity.getId());
    }

    @Override
    public boolean deleteById(String objectId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)objectId));
        long count = this.decorator.remove(query, DesignerEntity.class);
        return count > 0L;
    }

    @Override
    public List<Designer> selectByIds(Collection<String> ids) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").in(ids));
        return this.decorator.find(query, DesignerEntity.class).stream().map(DesignerConvertor.INSTANCE::toBO).collect(Collectors.toList());
    }

    @Generated
    public RDesignerMongoDaoImpl(MongoRuntimeRepositoryDecorator decorator) {
        this.decorator = decorator;
    }
}

