package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.base.ErrorCodeConstants;
import com.digiwin.athena.convertor.assembly.VariableConverter;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.variable.VarDefNode;
import com.digiwin.athena.dto.assembly.variable.VarTreeNodeDTO;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.service.assembly.DVariableService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 变量管理
 */
@Slf4j
@RestController
@RequestMapping("/assembly/variable/d/")
@RequiredArgsConstructor
@Validated
public class DVariableController {

    private final DVariableService variableService;
    private final ManageBackgroundUserService manageBackgroundUserService;

    /**
     * 查询设计器变量树
     *
     * @param keys 变量key列表，如["sys","asset"]
     * @return 变量树节点列表
     * @see com.digiwin.athena.constants.enums.assembly.AssemblyVarSpecies
     */
    @GetMapping("/tree")
    public ResultDto<List<VarTreeNodeDTO>> queryVariableTree(@RequestParam(required = false) List<String> keys) {
        if (!manageBackgroundUserService.isManager()) {
            throw new BusinessException(ErrorCodeConstants.Backend_Administrator_EXCEPTION, new Object[]{});
        }

        log.debug("收到查询设计器变量树请求，keys: {}", keys);
        List<VarDefNode> result = variableService.queryVariableTree(keys);
        return ResultDto.createSuccess(VariableConverter.INSTANCE.toDto(result));
    }
}
