package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.dao.mongodao.assembly.RSolutionMongoDao;
import com.digiwin.athena.datacollect.expression.ExpressionResolver;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.DVariableService;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import com.digiwin.athena.service.assembly.RVariableService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 运行时SolutionPlan列表服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RSolutionPlanServiceImpl implements RSolutionPlanService {

    private final RSolutionMongoDao rSolutionMongoDao;
    private final DVariableService variableService;
    private final RVariableService rVariableService;
    private final ExpressionResolver expressionResolver;


    @Override
    public Pagination<SolutionPlanListDTO> list(PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        // TODO pzz 查询运行时设计器最新名称及type
        return rSolutionMongoDao.selectOnlineSolutionPage(pageReqCondition);
    }

    @Override
    public List<SolutionPlanListDTO> findByAppTypeOrAll(List<Integer> appType) {
        return rSolutionMongoDao.selectByAppType(new HashSet<>(appType));
    }

    @Override
    public String resolveSsoUrl(SolutionPlanDetailDTO.SsoConfigDTO ssoConfig) {
        if (ssoConfig == null) {
            return null;
        }
        // TODO pzz 性能优化
        Map<String, Object> contextMap = rVariableService.getRuntimeVarMap("SolutionPlan_Sso");
        String url = expressionResolver.resolveToStr(ssoConfig.getUrl(), contextMap);

        Map<String, Object> paramMap = ssoConfig.toParamMap();
        paramMap.entrySet().stream()
                .filter(v -> SolutionPlanDetailDTO.SsoConfigDTO.KEY_EXPRESSION.equals(v.getKey()))
                .forEach(entry -> entry.setValue(expressionResolver.wrapVarName(StrUtil.toStringOrNull(entry.getValue()))));

        Map<String, Object> resolvedMap = expressionResolver.resolveMap(paramMap,
                contextMap, SolutionPlanDetailDTO.SsoConfigDTO.KEY_EXPRESSION);

        // 使用hutool构建请求url，url为ssoConfig的url，param为resolvedMap
        UrlBuilder urlBuilder = UrlBuilder.of(url);
        resolvedMap.forEach(urlBuilder::addQuery);

        return urlBuilder.build();
    }

    @Override
    public SolutionPlan findByAppType(Integer appType) {
        return rSolutionMongoDao.selectByAppType(appType);
    }
}
