/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.job;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dao.mongodao.datacollect.JobExecutionRecordMongoDao;
import com.digiwin.athena.datacollect.collector.BaseAssetDataCollector;
import com.digiwin.athena.datacollect.consumer.CollectDataConsumer;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.model.CollectResult;
import com.digiwin.athena.datacollect.model.JobExecData;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.mongodb.domain.datacollect.JobExecutionRecord;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AssetDataCollectJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetDataCollectJob.class);
    private final RAssetTypeMongoDao rAssetTypeMongoDao;
    private final JobExecutionRecordMongoDao jobExecutionRecordMongoDao;
    private final AssetDataCollectService assetDataCollectService;
    private final AssemblyProp assemblyProp;
    private final List<BaseAssetDataCollector> collectors;
    private Map<String, BaseAssetDataCollector> collectorMap;
    private ThreadPoolExecutor executorService;
    private ScheduledExecutorService timeoutMonitorService;

    @PostConstruct
    public void init() {
        if (!Boolean.TRUE.equals(this.assemblyProp.getJob().getEnabled())) {
            log.debug("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u5b9a\u65f6\u4efb\u52a1\u5173\u95ed\uff01");
            return;
        }
        this.executorService = new ThreadPoolExecutor(0, this.assemblyProp.getJob().getMaxThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.assemblyProp.getJob().getMaxRunJob()), ThreadUtil.createThreadFactoryBuilder().setNamePrefix("asset-dataCollector-").setUncaughtExceptionHandler((t, e) -> log.error("\u6570\u636e\u91c7\u96c6\u672a\u6355\u83b7\u5f02\u5e38\uff01msg:{}", (Object)e.getMessage(), (Object)e)).build(), new ThreadPoolExecutor.AbortPolicy());
        this.timeoutMonitorService = Executors.newScheduledThreadPool(1, ThreadUtil.createThreadFactoryBuilder().setNamePrefix("asset-timeout-monitor-").build());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (!Boolean.TRUE.equals(this.assemblyProp.getJob().getEnabled())) {
            return;
        }
        JobExecutor executor = new JobExecutor(context);
        try {
            Future<?> future = this.executorService.submit(executor);
            this.timeoutMonitorService.schedule(() -> {
                if (!future.isDone()) {
                    future.cancel(true);
                    log.warn("\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff0c\u6253\u65ad\u4efb\u52a1: assetTypeKey={}", (Object)executor.getAssetType().getKey());
                }
            }, this.assemblyProp.getJob().getTimeout().toMinutes(), TimeUnit.MINUTES);
        }
        catch (RejectedExecutionException e) {
            log.error("\u4efb\u52a1\u6267\u884c\u88ab\u62d2\u7edd\uff0c\u7ebf\u7a0b\u6c60\u5df2\u6ee1!\u6700\u5927\u503c\uff1a{} \u8fd0\u884c\u6570\uff1a{}", new Object[]{this.executorService.getQueue().size(), this.executorService.getTaskCount(), e});
        }
    }

    @Generated
    public AssetDataCollectJob(RAssetTypeMongoDao rAssetTypeMongoDao, JobExecutionRecordMongoDao jobExecutionRecordMongoDao, AssetDataCollectService assetDataCollectService, AssemblyProp assemblyProp, List<BaseAssetDataCollector> collectors) {
        this.rAssetTypeMongoDao = rAssetTypeMongoDao;
        this.jobExecutionRecordMongoDao = jobExecutionRecordMongoDao;
        this.assetDataCollectService = assetDataCollectService;
        this.assemblyProp = assemblyProp;
        this.collectors = collectors;
    }

    public class JobExecutor
    implements Runnable {
        private final String assetTypeId;
        private final String jobName;
        private final LocalDateTime fireTime;
        private AssetType assetType;
        private DataCollectConfig config;
        private JobExecutionRecord record;
        private CollectContext collectContext;
        private CollectResult result;

        public JobExecutor(JobExecutionContext context) {
            this.jobName = context.getJobDetail().getKey().getName();
            this.fireTime = LocalDateTimeUtil.of((Date)context.getFireTime());
            this.assetTypeId = context.getJobDetail().getJobDataMap().getString("assetTypeId");
        }

        @Override
        public void run() {
            try {
                log.info("\u5f00\u59cb\u6267\u884c\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1: jobName={}, assetTypeId={}", (Object)this.jobName, (Object)this.assetTypeId);
                this.init();
                this.executeDataCollection();
                this.record.complete(this.config, this.assetType, this.collectContext, this.result);
                log.info("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u6267\u884c\u5b8c\u6210: jobRecord\uff1a{}", (Object)this.record);
            }
            catch (Exception e) {
                log.error("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u6267\u884c\u5931\u8d25: msg:{}, jobRecord{}", new Object[]{e.getMessage(), this.record, e});
                this.record.fail(this.collectContext, e.getMessage());
            }
            finally {
                AssetDataCollectJob.this.jobExecutionRecordMongoDao.save(this.record);
            }
        }

        protected void init() {
            if (AssetDataCollectJob.this.collectorMap == null) {
                AssetDataCollectJob.this.collectorMap = AssetDataCollectJob.this.collectors.stream().collect(Collectors.toMap(BaseAssetDataCollector::getType, c -> c));
            }
            this.loadAssetTypeAndConfig();
            this.record = JobExecutionRecord.initExecRecord(this.jobName, this.fireTime, this.assetType.getKey());
            this.buildContext();
        }

        protected void loadAssetTypeAndConfig() {
            this.assetType = AssetDataCollectJob.this.rAssetTypeMongoDao.selectById(this.assetTypeId);
            if (this.assetType == null) {
                throw new BusinessException("\u8d44\u4ea7\u7c7b\u578b\u4e0d\u5b58\u5728: " + this.assetTypeId);
            }
            this.config = DataCollectConfig.fromAssetType(this.assetType);
            if (this.config == null || this.config.getExecutor() == null) {
                throw new BusinessException("\u8d44\u4ea7\u7c7b\u578b\u672a\u914d\u7f6e\u6570\u636e\u91c7\u96c6: " + this.assetType.getType());
            }
        }

        protected void executeDataCollection() {
            String executorType = this.config.getExecutor().getType();
            BaseAssetDataCollector collector = AssetDataCollectJob.this.collectorMap.get(executorType);
            if (collector == null) {
                throw new BusinessException("\u4e0d\u652f\u6301\u7684\u91c7\u96c6\u5668\u7c7b\u578b: " + executorType);
            }
            CollectDataConsumer consumer = AssetDataCollectJob.this.assetDataCollectService::batchProcessDataItems;
            this.result = collector.collect(this.collectContext, consumer);
        }

        protected void buildContext() {
            JobExecData presetExecData;
            JobExecutionRecord lastExecRecord = AssetDataCollectJob.this.jobExecutionRecordMongoDao.findLatestByBizKey(this.assetType.getKey());
            JobExecData jobExecData = presetExecData = lastExecRecord != null ? lastExecRecord.getNextExecData() : null;
            if (this.config.isConfigChanged(lastExecRecord)) {
                log.warn("\u68c0\u6d4b\u5230\u914d\u7f6e\u66f4\u65b0\uff0c\u7ed3\u675f\u5f53\u524d\u4efb\u52a1\u5e76\u91cd\u65b0\u5f00\u59cb: assetTypeKey={}, oldConfigTime={}, newConfigTime={}", new Object[]{this.assetType.getKey(), lastExecRecord != null ? lastExecRecord.obtainConfigUpdateTime() : null, this.config.getConfigUpdateTime()});
                presetExecData = null;
            }
            this.collectContext = CollectContext.buildCollectContext(this.config, AssetDataCollectJob.this.assemblyProp.getCollector(), this.assetType, presetExecData, this.fireTime);
        }

        @Generated
        public String getAssetTypeId() {
            return this.assetTypeId;
        }

        @Generated
        public String getJobName() {
            return this.jobName;
        }

        @Generated
        public LocalDateTime getFireTime() {
            return this.fireTime;
        }

        @Generated
        public AssetType getAssetType() {
            return this.assetType;
        }

        @Generated
        public DataCollectConfig getConfig() {
            return this.config;
        }

        @Generated
        public JobExecutionRecord getRecord() {
            return this.record;
        }

        @Generated
        public CollectContext getCollectContext() {
            return this.collectContext;
        }

        @Generated
        public CollectResult getResult() {
            return this.result;
        }
    }
}

