package com.digiwin.athena.convertor.assembly;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.variable.VarDefMapNode;
import com.digiwin.athena.dto.assembly.variable.VarDefNode;
import com.digiwin.athena.dto.assembly.variable.VarTreeNodeDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Mapper(uses = {BaseConverter.class})
public interface VariableConverter {

    VariableConverter INSTANCE = Mappers.getMapper(VariableConverter.class);

    List<VarTreeNodeDTO> toDto(List<VarDefNode> result);

    VarDefNode toDefNode(VarDefMapNode resolve);

    VarDefMapNode toMapNode(VarDefNode var);

    default Map<String, VarDefMapNode> toMap(List<VarDefNode> result) {
        return CollUtil.emptyIfNull(result).stream()
                .map(this::toMapNode)
                .collect(Collectors.toMap(VarDefMapNode::getVarName, v -> v));
    }

    default List<VarDefNode> toList(Map<String, VarDefMapNode> map) {
        return MapUtil.emptyIfNull(map).values().stream()
                .map(this::toDefNode)
                .collect(Collectors.toList());
    }

}

