package com.digiwin.athena.service.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 运行时Designer列表服务接口
 */
public interface RDesignerService {

    /**
     * 分页查询在线状态的设计器列表
     *
     * @param pageReqCondition 分页查询条件
     * @return 分页结果
     */
    Pagination<DesignerListDTO> getOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageReqCondition);

    List<Designer> getDesigners(Collection<String> ids);
}
