/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.mongodb.domain.datacollect;

import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.model.CollectResult;
import com.digiwin.athena.datacollect.model.JobBizData;
import com.digiwin.athena.datacollect.model.JobExecData;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="job_execution_record")
public class JobExecutionRecord {
    @Id
    private String id;
    private String jobName;
    private LocalDateTime fireTime;
    private LocalDateTime finishTime;
    private String status;
    private String bizKey;
    private JobBizData bizData;
    private JobExecData nextExecData;
    private String errorMessage;
    private Long durationMs;
    private LocalDateTime createdAt;

    public static JobExecutionRecord initExecRecord(String jobName, LocalDateTime fireTime, String assetTypeKey) {
        JobExecutionRecord record = new JobExecutionRecord();
        record.setJobName(jobName);
        record.setBizKey(assetTypeKey);
        record.setFireTime(fireTime);
        record.setCreatedAt(LocalDateTime.now());
        record.setStatus("RUNNING");
        return record;
    }

    public LocalDateTime obtainConfigUpdateTime() {
        return Optional.ofNullable(this.getBizData()).map(JobBizData::getConfigUpdateTime).orElse(null);
    }

    public void fail(CollectContext collectContext, String errorMessage) {
        this.setStatus("FAILURE");
        this.setFinishTime(LocalDateTime.now());
        this.setDurationMs(ChronoUnit.MILLIS.between(this.getFireTime(), this.getFinishTime()));
        this.setErrorMessage(errorMessage);
        if (collectContext != null) {
            JobExecData failedNextData = this.buildNextData(collectContext);
            this.setNextExecData(failedNextData);
        }
    }

    public void complete(DataCollectConfig config, AssetType assetType, CollectContext context, CollectResult result) {
        this.setStatus(result.isSuccess() ? "SUCCESS" : "FAILURE");
        this.setFinishTime(result.getEndTime());
        this.setDurationMs(ChronoUnit.MILLIS.between(this.getFireTime(), this.getFinishTime()));
        JobBizData bizData = this.buildBizData(assetType, config, context);
        this.setBizData(bizData);
        JobExecData nextData = this.buildNextData(result, context);
        this.setNextExecData(nextData);
        if (!result.isSuccess()) {
            this.setErrorMessage(result.getErrorMessage());
        }
    }

    protected JobBizData buildBizData(AssetType assetType, DataCollectConfig config, CollectContext context) {
        JobBizData bizData = new JobBizData();
        bizData.setAssetTypeId(assetType.getKey());
        bizData.setAssetType(assetType.getType());
        bizData.setAssetTypeName(assetType.getName());
        bizData.setConfigUpdateTime(config.getConfigUpdateTime());
        bizData.setStatus(assetType.getStatus());
        bizData.setTotalCount(context.getTotalRecords());
        bizData.setConsumedCount(context.getConsumedRecords());
        bizData.setTotalPages(context.getTotalPages());
        bizData.setTotalSteps(context.getTotalSteps());
        return bizData;
    }

    protected JobExecData buildNextData(CollectResult result, CollectContext context) {
        JobExecData nextData = new JobExecData();
        if (result.isSuccess()) {
            nextData.setLastCollectTime(result.getEndTime());
            nextData.setStartTime(context.getCurrentStepEndTime());
        } else {
            nextData = this.buildNextData(context);
        }
        return nextData;
    }

    protected JobExecData buildNextData(CollectContext context) {
        JobExecData nextData = new JobExecData();
        nextData.setLastCollectTime(context.getFireTime());
        nextData.setStartTime(context.getStartTime());
        nextData.setEndTime(context.getEndTime());
        nextData.setPageNo(context.getPageNo());
        nextData.setLoopIndex(context.getLoopIndex());
        nextData.setStepStartTime(context.getCurrentStepStartTime());
        nextData.setStepEndTime(context.getCurrentStepEndTime());
        return nextData;
    }

    @Generated
    public JobExecutionRecord() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public LocalDateTime getFireTime() {
        return this.fireTime;
    }

    @Generated
    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getBizKey() {
        return this.bizKey;
    }

    @Generated
    public JobBizData getBizData() {
        return this.bizData;
    }

    @Generated
    public JobExecData getNextExecData() {
        return this.nextExecData;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public void setFireTime(LocalDateTime fireTime) {
        this.fireTime = fireTime;
    }

    @Generated
    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    @Generated
    public void setBizData(JobBizData bizData) {
        this.bizData = bizData;
    }

    @Generated
    public void setNextExecData(JobExecData nextExecData) {
        this.nextExecData = nextExecData;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobExecutionRecord)) {
            return false;
        }
        JobExecutionRecord other = (JobExecutionRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$durationMs = this.getDurationMs();
        Long other$durationMs = other.getDurationMs();
        if (this$durationMs == null ? other$durationMs != null : !((Object)this$durationMs).equals(other$durationMs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        LocalDateTime this$fireTime = this.getFireTime();
        LocalDateTime other$fireTime = other.getFireTime();
        if (this$fireTime == null ? other$fireTime != null : !((Object)this$fireTime).equals(other$fireTime)) {
            return false;
        }
        LocalDateTime this$finishTime = this.getFinishTime();
        LocalDateTime other$finishTime = other.getFinishTime();
        if (this$finishTime == null ? other$finishTime != null : !((Object)this$finishTime).equals(other$finishTime)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$bizKey = this.getBizKey();
        String other$bizKey = other.getBizKey();
        if (this$bizKey == null ? other$bizKey != null : !this$bizKey.equals(other$bizKey)) {
            return false;
        }
        JobBizData this$bizData = this.getBizData();
        JobBizData other$bizData = other.getBizData();
        if (this$bizData == null ? other$bizData != null : !((Object)this$bizData).equals(other$bizData)) {
            return false;
        }
        JobExecData this$nextExecData = this.getNextExecData();
        JobExecData other$nextExecData = other.getNextExecData();
        if (this$nextExecData == null ? other$nextExecData != null : !((Object)this$nextExecData).equals(other$nextExecData)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobExecutionRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $durationMs = this.getDurationMs();
        result = result * 59 + ($durationMs == null ? 43 : ((Object)$durationMs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        LocalDateTime $fireTime = this.getFireTime();
        result = result * 59 + ($fireTime == null ? 43 : ((Object)$fireTime).hashCode());
        LocalDateTime $finishTime = this.getFinishTime();
        result = result * 59 + ($finishTime == null ? 43 : ((Object)$finishTime).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $bizKey = this.getBizKey();
        result = result * 59 + ($bizKey == null ? 43 : $bizKey.hashCode());
        JobBizData $bizData = this.getBizData();
        result = result * 59 + ($bizData == null ? 43 : ((Object)$bizData).hashCode());
        JobExecData $nextExecData = this.getNextExecData();
        result = result * 59 + ($nextExecData == null ? 43 : ((Object)$nextExecData).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobExecutionRecord(id=" + this.getId() + ", jobName=" + this.getJobName() + ", fireTime=" + String.valueOf(this.getFireTime()) + ", finishTime=" + String.valueOf(this.getFinishTime()) + ", status=" + this.getStatus() + ", bizKey=" + this.getBizKey() + ", bizData=" + String.valueOf(this.getBizData()) + ", nextExecData=" + String.valueOf(this.getNextExecData()) + ", errorMessage=" + this.getErrorMessage() + ", durationMs=" + this.getDurationMs() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    public static class Status {
        public static final String SUCCESS = "SUCCESS";
        public static final String FAILURE = "FAILURE";
        public static final String RUNNING = "RUNNING";
    }
}

