package com.digiwin.athena.datacollect.model;

import lombok.Data;

import java.util.List;

/**
 * 分页查询结果
 *
 * @param <T> 数据类型
 */
@Data
public class PageResult<T> {

    /**
     * 当前页数据
     */
    private List<T> data;

    /**
     * 是否还有更多数据
     */
    private boolean hasMore = false;

    /**
     * 当前页码
     */
    private int currentPage;

    /**
     * 每页大小
     */
    private int pageSize;

    /**
     * 当前页数据量
     */
    private int currentPageSize;

    /**
     * 构造方法
     */
    public PageResult() {
    }

    /**
     * 构造方法
     *
     * @param data        当前页数据
     * @param currentPage 当前页码
     * @param pageSize    每页大小
     */
    public PageResult(List<T> data, int currentPage, int pageSize) {
        this.data = data;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.currentPageSize = data != null ? data.size() : 0;
        this.hasMore = this.currentPageSize >= pageSize;
    }

    /**
     * 是否为空
     */
    public boolean isEmpty() {
        return data == null || data.isEmpty();
    }
}
