package com.digiwin.athena.dto.asset;

import com.digiwin.athena.mongodb.domain.application.AssetRelation;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class DependentAssetResDto {

    @Schema(description = "引用记录的objectId")
    private String objectId;

    private String assetId;
    private String assetName;

    private String assetDesc;
    private String publisher;

    private String publisherName;

    private String application;

    private String type;
    private String code;

    @Schema(description = "引用是否失效")
    private Boolean referenceInvalid=true;
    @Schema(description = "当前被引用方的生效版本")
    private String adpVersion;
    @Schema(description = "当前被引用方的备注序列号")
    private Integer adpRemarkNumber;

    private AssetRelation assetRelation;
}
