/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.model;

import com.digiwin.athena.datacollect.context.CollectContext;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

public class CollectResult {
    private String assetType;
    private boolean success;
    private String errorMessage;
    private LocalDateTime startTime;
    private LocalDateTime endTime;

    public static CollectResult buildSuccess(CollectContext context, LocalDateTime startTime) {
        LocalDateTime now = LocalDateTime.now();
        CollectResult result = new CollectResult();
        result.setSuccess(true);
        result.setAssetType(context.getAssetType().getType());
        result.setStartTime(startTime);
        result.setEndTime(now);
        return result;
    }

    public static CollectResult buildFailed(Exception e, CollectContext context, LocalDateTime startTime) {
        CollectResult result = new CollectResult();
        result.setSuccess(false);
        result.setAssetType(context.getAssetType().getType());
        result.setStartTime(startTime);
        result.setEndTime(LocalDateTime.now());
        result.setErrorMessage(e.getMessage());
        return result;
    }

    public long getDurationMs() {
        if (this.startTime != null && this.endTime != null) {
            return ChronoUnit.MILLIS.between(this.startTime, this.endTime);
        }
        return 0L;
    }

    @Generated
    public CollectResult() {
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectResult)) {
            return false;
        }
        CollectResult other = (CollectResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectResult(assetType=" + this.getAssetType() + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ")";
    }
}

