package com.digiwin.athena.mq;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.service.asset.AssetDataCollectService;
import com.rabbitmq.client.Channel;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

@Component
@Slf4j
@ConditionalOnBean(name = {"rabbitMQConfig"})
@ConditionalOnProperty(prefix = "rabbitmq.mdc", name = "assetDataSyncQueueName")
@RequiredArgsConstructor
public class AssetDataConsumerListener {

    private final AssetDataCollectService assetDataCollectService;
    @RabbitListener(containerFactory = "manualAckContainerFactory", queues = "${rabbitmq.mdc.assetDataSyncQueueName}")
    public void mdcMetadataListener(String message, Channel channel, Message msg) throws IOException {

        try {
            AssetCollectApiResponse.AssetDataItem assetDataItem = JSONObject.parseObject(message, AssetCollectApiResponse.AssetDataItem.class);
            AssetCollectApiResponse.AssetData data = assetDataItem.getData();
            log.info("Receive message,code={}, type={}, manageContext={}", data.getCode(),data.getType(),JSONObject.toJSONString(data.getManageContext()));

            assetDataCollectService.batchProcessDataItems(new CollectContext(), List.of(assetDataItem));

        } catch (Exception e) {
            log.error("消费异常:"+message,e);
        } finally {
            channel.basicAck(msg.getMessageProperties().getDeliveryTag(),false);
        }
    }
}
