/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.collector;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.datacollect.consumer.CollectDataConsumer;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.expression.ExpressionResolver;
import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import com.digiwin.athena.datacollect.model.CollectResult;
import com.digiwin.athena.datacollect.model.PageResult;
import com.digiwin.athena.datacollect.script.ScriptExecutor;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseAssetDataCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAssetDataCollector.class);
    protected ScriptExecutor scriptExecutor;
    protected ExpressionResolver expressionResolver;

    public abstract String getType();

    public CollectResult collect(CollectContext context, CollectDataConsumer consumer) {
        LocalDateTime startTime = LocalDateTime.now();
        try {
            this.initContextExecutorParam(context);
            context.begin();
            while (context.hasNext()) {
                log.info("\u5f00\u59cb\u6b65\u8fdb\u67e5\u8be2: assetTypeKey={}, step={}, startTime={}, endTime={}", new Object[]{context.getAssetType().getKey(), context.getTotalSteps() + 1, context.getCurrentStepStartTime(), context.getCurrentStepEndTime()});
                List<Map<String, Object>> loopParams = context.getConfig().getExecutor().getLoopParams();
                if (CollUtil.isNotEmpty(loopParams)) {
                    for (int loopIndex = context.getLoopIndex().intValue(); loopIndex < loopParams.size(); ++loopIndex) {
                        Map<String, Object> loopParam = loopParams.get(loopIndex);
                        context.setLoopParam(loopParam);
                        context.setLoopIndex(loopIndex);
                        this.executePagingCollect(context, consumer);
                    }
                } else {
                    this.executePagingCollect(context, consumer);
                }
                context.step();
            }
            log.info("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u6210\u529f: assetTypeKey={}, steps={}, pages={}, totalCount={}, consumedCount={}", new Object[]{context.getAssetType().getKey(), context.getTotalSteps(), context.getTotalPages(), context.getTotalRecords(), context.getConsumedRecords()});
            return CollectResult.buildSuccess(context, startTime);
        }
        catch (Exception e) {
            log.error("\u8d44\u4ea7\u6570\u636e\u91c7\u96c6\u5931\u8d25: assetTypeKey={}", (Object)context.getAssetType().getKey(), (Object)e);
            return CollectResult.buildFailed(e, context, startTime);
        }
    }

    protected void executePagingCollect(CollectContext context, CollectDataConsumer consumer) throws Exception {
        boolean hasMore = true;
        while (hasMore) {
            log.debug("\u67e5\u8be2\u7b2c{}\u9875: assetTypeKey={}, loopIndex={}", new Object[]{context.getPageNo(), context.getAssetType().getKey(), context.getLoopIndex()});
            PageResult<AssetCollectApiResponse.AssetDataItem> pageResult = this.fetchPage(context);
            if (!pageResult.isEmpty()) {
                int consumedCount = consumer.consume(context, pageResult.getData());
                context.addRecords(pageResult.getData().size(), consumedCount);
                log.debug("\u7b2c{}\u9875\u6d88\u8d39\u5b8c\u6210: fetchedCount={}, consumedCount={}", new Object[]{context.getPageNo(), pageResult.getData().size(), consumedCount});
            }
            hasMore = pageResult.isHasMore();
            context.incrementPageNo();
        }
    }

    protected void initContextExecutorParam(CollectContext context) {
        DataCollectConfig config = context.getConfig();
        if (config == null || config.getExecutor() == null) {
            return;
        }
        CollectExecutorProp executor = config.getExecutor();
        Map<String, Object> expressionContext = this.getExpressionContext();
        if (executor.getUrl() != null) {
            executor.setUrl(this.expressionResolver.resolveToStr(executor.getUrl(), expressionContext));
        }
        if (executor.getHeaders() != null) {
            executor.setHeaders(this.expressionResolver.resolveMap(executor.getHeaders(), expressionContext, new String[0]));
        }
        if (executor.getLoopParams() != null && !executor.getLoopParams().isEmpty()) {
            List<Map<String, Object>> mapList = this.expressionResolver.resolveList(executor.getLoopParams(), expressionContext, new String[0]);
            executor.setLoopParams(mapList);
        }
    }

    protected Map<String, Object> getExpressionContext() {
        return Collections.emptyMap();
    }

    protected abstract PageResult<AssetCollectApiResponse.AssetDataItem> fetchPage(CollectContext var1) throws Exception;

    @Autowired
    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    @Autowired
    public void setExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }
}

