package com.digiwin.athena.integration.assembly.gmc.api;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.CreateCommodityRequest;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.GmcResultDto;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.UpdateCommodityRequest;
import com.digiwin.athena.integration.assembly.gmc.dto.commodity.UpdateModulesRequest;
import org.springframework.stereotype.Component;

@Component
public class GmcCommodityApi {

    public GmcResultDto<Boolean> createCommodity(String url, String appToken, String iamToken,
                                                             CreateCommodityRequest request) {
        String responseBody = HttpUtil.createPost(url)
                .body(BaseConverter.INSTANCE.serialize(request))
                .header("digi-middleware-auth-user", iamToken)
                .header("digi-middleware-auth-app", appToken)
                .execute()
                .body();

        return BaseConverter.INSTANCE.deserialize(responseBody, GmcResultDto.class, Boolean.class);
    }

    public GmcResultDto<Void> updateModule(String gmcUrl, String appToken, String iamToken,
                                           UpdateModulesRequest request) {
        String responseBody = HttpUtil.createPost(gmcUrl)
                .header("digi-middleware-auth-user", iamToken)
                .header("digi-middleware-auth-app", appToken)
                .body(BaseConverter.INSTANCE.serialize(request))
                .execute()
                .body();

        return BaseConverter.INSTANCE.deserialize(responseBody, GmcResultDto.class, Object.class);
    }

    public GmcResultDto<Void> updateCommodity(String gmcUrl, String appToken, String iamToken, UpdateCommodityRequest request) {
        String responseBody = HttpUtil.createRequest(Method.PUT, gmcUrl)
                .header("digi-middleware-auth-user", iamToken)
                .header("digi-middleware-auth-app", appToken)
                .body(BaseConverter.INSTANCE.serialize(request))
                .execute()
                .body();

        return BaseConverter.INSTANCE.deserialize(responseBody, GmcResultDto.class, Object.class);
    }
}
