/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.convertor.assembly.VariableConverter;
import com.digiwin.athena.datacollect.expression.ExpressionResolver;
import com.digiwin.athena.dto.assembly.variable.VarDefMapNode;
import com.digiwin.athena.dto.assembly.variable.VarDefNode;
import com.digiwin.athena.dto.assembly.variable.VarTreeNodeDTO;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.assembly.DVariableService;
import com.digiwin.athena.sys.PresetDataServiceV2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DVariableServiceImpl
implements DVariableService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DVariableServiceImpl.class);
    public static final String PRESET_DATA_KEY_VAR_TREE = "Assembly_Var_Tree";
    public static final String VAR_DEFAULT = "Default";
    protected final PresetDataServiceV2 presetDataServiceV2;
    protected final ExpressionResolver expressionResolver;

    @Override
    public List<VarTreeNodeDTO> queryVariableTree(List<String> keys) {
        List<VarDefMapNode> varDefMapNodes;
        List<VarTreeNodeDTO> treeList;
        if (CollUtil.isEmpty(keys)) {
            keys = Collections.singletonList(VAR_DEFAULT);
        }
        if ((treeList = VariableConverter.INSTANCE.toDto(varDefMapNodes = this.resolveVarDef(keys))).size() == 1) {
            return treeList.get(0).getChildren();
        }
        return treeList;
    }

    protected List<VarDefNode> getVarTreeList() {
        PresetData presetData = this.presetDataServiceV2.getPresetDataObjectV2(PRESET_DATA_KEY_VAR_TREE);
        if (presetData == null || presetData.getObj() == null) {
            throw new BusinessException("\u672a\u627e\u5230\u53d8\u91cf\u6811\u914d\u7f6e\u6570\u636e\uff01");
        }
        List<VarDefNode> varNodeList = BaseConverter.INSTANCE.copyToList((Collection)presetData.getObj(), VarDefNode.class);
        if (varNodeList == null || varNodeList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230\u53d8\u91cf\u6811\u914d\u7f6e\u6570\u636e\uff01");
        }
        return varNodeList;
    }

    @Override
    public VarDefMapNode resolveVarDef(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return null;
        }
        return (VarDefMapNode)CollUtil.getFirst(this.resolveVarDef(Collections.singletonList(key)));
    }

    @Override
    public List<VarDefMapNode> resolveVarDef(List<String> keys) {
        if (CollUtil.isEmpty(keys)) {
            return Collections.emptyList();
        }
        List<VarDefNode> varTreeList = this.getVarTreeList();
        Map<String, VarDefMapNode> varTreeMap = VariableConverter.INSTANCE.toMap(varTreeList);
        List varDefList = CollUtil.emptyIfNull(varTreeList).stream().filter(v -> keys.contains(v.getValue())).collect(Collectors.toList());
        if (CollUtil.isEmpty(varDefList)) {
            return Collections.emptyList();
        }
        return varDefList.stream().map(var -> this.resolveVarDef((VarDefNode)var, varTreeMap)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected VarDefMapNode resolveVarDef(VarDefNode var, Map<String, VarDefMapNode> varTreeMap) {
        if (var == null) {
            return null;
        }
        VarDefMapNode mapNode = VariableConverter.INSTANCE.toMapNode(var);
        ExpressionResolver.BeanAccessor<VarDefMapNode> beanAccessor = ExpressionResolver.BeanAccessor.create().addMapping(VarDefMapNode.class, VarDefMapNode::getReference, (node, v) -> {
            if (v instanceof VarDefMapNode) {
                VarDefMapNode referenceNode = (VarDefMapNode)v;
                node.putReference(referenceNode);
            } else {
                log.error("\u53d8\u91cf\u6811\u5b9a\u4e49\u8868\u8fbe\u5f0f\u89e3\u6790\u540e\u4e0d\u4e3a\u8282\u70b9\uff01nodeFullPath:{},expression:{},evalResult:{}", new Object[]{node.getFullPath(), node.getReference(), v});
            }
        }, VarDefMapNode::getChildren);
        return this.expressionResolver.resolve(mapNode, varTreeMap, beanAccessor, new String[0]);
    }

    @Override
    public VarDefNode resolveVarDefList(String key) {
        return VariableConverter.INSTANCE.toDefNode(this.resolveVarDef(key));
    }

    @Generated
    public DVariableServiceImpl(PresetDataServiceV2 presetDataServiceV2, ExpressionResolver expressionResolver) {
        this.presetDataServiceV2 = presetDataServiceV2;
        this.expressionResolver = expressionResolver;
    }
}

