/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto.assembly.solution;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.athena.common.dict.Dict;
import com.digiwin.athena.constants.enums.assembly.AssemblyType;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class SolutionPlanListDTO {
    private String id;
    private String name;
    private String type;
    private Integer category;
    private Integer appType;
    @Dict(enumClass=AssemblyType.class)
    private String assemblyType;
    private SolutionPlanDetailDTO.SsoConfigDTO ssoConfig;
    private List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList;
    private String owner;
    @Dict(enumClass=OnlineState.class)
    private String status;
    private String version;
    private Boolean isStdPublish;
    private Integer popularSort;
    private Integer frontBizSetupPageIdx;
    private Map<String, MultiLanguageDTO<String>> lang;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime publishTime;
    private String publishBy;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    private String createBy;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime editTime;
    private String editBy;

    public static List<String> obtainDesignerIds(List<SolutionPlanListDTO> list) {
        return CollUtil.emptyIfNull(list).stream().flatMap(v -> v.obtainDesignerIds().stream()).distinct().toList();
    }

    public static void sort(List<SolutionPlanListDTO> list) {
        list.sort(Comparator.comparingLong(SolutionPlanListDTO::obtainShowSort));
    }

    public Boolean getIsAssemblable() {
        return AssemblyType.isAssemblable(this.assemblyType);
    }

    public List<String> obtainDesignerIds() {
        return CollUtil.emptyIfNull(this.getDesignerList()).stream().map(SolutionPlanDetailDTO.DesignerBaseInfoDTO::getId).distinct().collect(Collectors.toList());
    }

    public long obtainShowSort() {
        return OnlineState.isOff(this.getStatus()) ? Long.MAX_VALUE : LocalDateTimeUtil.toEpochMilli((TemporalAccessor)this.getCreateTime());
    }

    @Generated
    public SolutionPlanListDTO() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getCategory() {
        return this.category;
    }

    @Generated
    public Integer getAppType() {
        return this.appType;
    }

    @Generated
    public String getAssemblyType() {
        return this.assemblyType;
    }

    @Generated
    public SolutionPlanDetailDTO.SsoConfigDTO getSsoConfig() {
        return this.ssoConfig;
    }

    @Generated
    public List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> getDesignerList() {
        return this.designerList;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getIsStdPublish() {
        return this.isStdPublish;
    }

    @Generated
    public Integer getPopularSort() {
        return this.popularSort;
    }

    @Generated
    public Integer getFrontBizSetupPageIdx() {
        return this.frontBizSetupPageIdx;
    }

    @Generated
    public Map<String, MultiLanguageDTO<String>> getLang() {
        return this.lang;
    }

    @Generated
    public LocalDateTime getPublishTime() {
        return this.publishTime;
    }

    @Generated
    public String getPublishBy() {
        return this.publishBy;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getCreateBy() {
        return this.createBy;
    }

    @Generated
    public LocalDateTime getEditTime() {
        return this.editTime;
    }

    @Generated
    public String getEditBy() {
        return this.editBy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCategory(Integer category) {
        this.category = category;
    }

    @Generated
    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    @Generated
    public void setAssemblyType(String assemblyType) {
        this.assemblyType = assemblyType;
    }

    @Generated
    public void setSsoConfig(SolutionPlanDetailDTO.SsoConfigDTO ssoConfig) {
        this.ssoConfig = ssoConfig;
    }

    @Generated
    public void setDesignerList(List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList) {
        this.designerList = designerList;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setIsStdPublish(Boolean isStdPublish) {
        this.isStdPublish = isStdPublish;
    }

    @Generated
    public void setPopularSort(Integer popularSort) {
        this.popularSort = popularSort;
    }

    @Generated
    public void setFrontBizSetupPageIdx(Integer frontBizSetupPageIdx) {
        this.frontBizSetupPageIdx = frontBizSetupPageIdx;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO<String>> lang) {
        this.lang = lang;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setPublishTime(LocalDateTime publishTime) {
        this.publishTime = publishTime;
    }

    @Generated
    public void setPublishBy(String publishBy) {
        this.publishBy = publishBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setEditTime(LocalDateTime editTime) {
        this.editTime = editTime;
    }

    @Generated
    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolutionPlanListDTO)) {
            return false;
        }
        SolutionPlanListDTO other = (SolutionPlanListDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$category = this.getCategory();
        Integer other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
            return false;
        }
        Integer this$appType = this.getAppType();
        Integer other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !((Object)this$appType).equals(other$appType)) {
            return false;
        }
        Boolean this$isStdPublish = this.getIsStdPublish();
        Boolean other$isStdPublish = other.getIsStdPublish();
        if (this$isStdPublish == null ? other$isStdPublish != null : !((Object)this$isStdPublish).equals(other$isStdPublish)) {
            return false;
        }
        Integer this$popularSort = this.getPopularSort();
        Integer other$popularSort = other.getPopularSort();
        if (this$popularSort == null ? other$popularSort != null : !((Object)this$popularSort).equals(other$popularSort)) {
            return false;
        }
        Integer this$frontBizSetupPageIdx = this.getFrontBizSetupPageIdx();
        Integer other$frontBizSetupPageIdx = other.getFrontBizSetupPageIdx();
        if (this$frontBizSetupPageIdx == null ? other$frontBizSetupPageIdx != null : !((Object)this$frontBizSetupPageIdx).equals(other$frontBizSetupPageIdx)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$assemblyType = this.getAssemblyType();
        String other$assemblyType = other.getAssemblyType();
        if (this$assemblyType == null ? other$assemblyType != null : !this$assemblyType.equals(other$assemblyType)) {
            return false;
        }
        SolutionPlanDetailDTO.SsoConfigDTO this$ssoConfig = this.getSsoConfig();
        SolutionPlanDetailDTO.SsoConfigDTO other$ssoConfig = other.getSsoConfig();
        if (this$ssoConfig == null ? other$ssoConfig != null : !((Object)this$ssoConfig).equals(other$ssoConfig)) {
            return false;
        }
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> this$designerList = this.getDesignerList();
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> other$designerList = other.getDesignerList();
        if (this$designerList == null ? other$designerList != null : !((Object)this$designerList).equals(other$designerList)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, MultiLanguageDTO<String>> this$lang = this.getLang();
        Map<String, MultiLanguageDTO<String>> other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang)) {
            return false;
        }
        LocalDateTime this$publishTime = this.getPublishTime();
        LocalDateTime other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        String this$publishBy = this.getPublishBy();
        String other$publishBy = other.getPublishBy();
        if (this$publishBy == null ? other$publishBy != null : !this$publishBy.equals(other$publishBy)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$createBy = this.getCreateBy();
        String other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !this$createBy.equals(other$createBy)) {
            return false;
        }
        LocalDateTime this$editTime = this.getEditTime();
        LocalDateTime other$editTime = other.getEditTime();
        if (this$editTime == null ? other$editTime != null : !((Object)this$editTime).equals(other$editTime)) {
            return false;
        }
        String this$editBy = this.getEditBy();
        String other$editBy = other.getEditBy();
        return !(this$editBy == null ? other$editBy != null : !this$editBy.equals(other$editBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolutionPlanListDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
        Integer $appType = this.getAppType();
        result = result * 59 + ($appType == null ? 43 : ((Object)$appType).hashCode());
        Boolean $isStdPublish = this.getIsStdPublish();
        result = result * 59 + ($isStdPublish == null ? 43 : ((Object)$isStdPublish).hashCode());
        Integer $popularSort = this.getPopularSort();
        result = result * 59 + ($popularSort == null ? 43 : ((Object)$popularSort).hashCode());
        Integer $frontBizSetupPageIdx = this.getFrontBizSetupPageIdx();
        result = result * 59 + ($frontBizSetupPageIdx == null ? 43 : ((Object)$frontBizSetupPageIdx).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $assemblyType = this.getAssemblyType();
        result = result * 59 + ($assemblyType == null ? 43 : $assemblyType.hashCode());
        SolutionPlanDetailDTO.SsoConfigDTO $ssoConfig = this.getSsoConfig();
        result = result * 59 + ($ssoConfig == null ? 43 : ((Object)$ssoConfig).hashCode());
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> $designerList = this.getDesignerList();
        result = result * 59 + ($designerList == null ? 43 : ((Object)$designerList).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, MultiLanguageDTO<String>> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        LocalDateTime $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        String $publishBy = this.getPublishBy();
        result = result * 59 + ($publishBy == null ? 43 : $publishBy.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : $createBy.hashCode());
        LocalDateTime $editTime = this.getEditTime();
        result = result * 59 + ($editTime == null ? 43 : ((Object)$editTime).hashCode());
        String $editBy = this.getEditBy();
        result = result * 59 + ($editBy == null ? 43 : $editBy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolutionPlanListDTO(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", category=" + this.getCategory() + ", appType=" + this.getAppType() + ", assemblyType=" + this.getAssemblyType() + ", ssoConfig=" + String.valueOf(this.getSsoConfig()) + ", designerList=" + String.valueOf(this.getDesignerList()) + ", owner=" + this.getOwner() + ", status=" + this.getStatus() + ", version=" + this.getVersion() + ", isStdPublish=" + this.getIsStdPublish() + ", popularSort=" + this.getPopularSort() + ", frontBizSetupPageIdx=" + this.getFrontBizSetupPageIdx() + ", lang=" + String.valueOf(this.getLang()) + ", publishTime=" + String.valueOf(this.getPublishTime()) + ", publishBy=" + this.getPublishBy() + ", createTime=" + String.valueOf(this.getCreateTime()) + ", createBy=" + this.getCreateBy() + ", editTime=" + String.valueOf(this.getEditTime()) + ", editBy=" + this.getEditBy() + ")";
    }
}

