/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.service.assembly.RDesignerService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RDesignerServiceImpl
implements RDesignerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDesignerServiceImpl.class);
    private final RDesignerMongoDao rDesignerMongoDao;

    @Override
    public Pagination<DesignerListDTO> getOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageParam) {
        log.debug("\u5206\u9875\u67e5\u8be2\u5728\u7ebf\u72b6\u6001\u7684\u8bbe\u8ba1\u5668\u5217\u8868");
        return this.rDesignerMongoDao.selectOnlineDesignerPage(pageParam);
    }

    @Override
    public List<Designer> getDesigners(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<Designer> designers = this.rDesignerMongoDao.selectByIds(ids);
        Designer.sort(designers);
        return designers;
    }

    @Override
    public Map<String, Designer> getDesignerMap(Collection<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        return CollUtil.toMap(this.getDesigners(ids), (Map)MapUtil.newHashMap((int)ids.size()), Designer::getId);
    }

    @Generated
    public RDesignerServiceImpl(RDesignerMongoDao rDesignerMongoDao) {
        this.rDesignerMongoDao = rDesignerMongoDao;
    }
}

