package com.digiwin.athena.constants.enums;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.dto.action.MultiLanguageDTO;

import java.util.Objects;

/**
 * 多语言枚举基类接口
 */
public interface BaseLangEnum<K> {
    static <K, T extends BaseLangEnum<K>> T byCodeObj(Class<T> enumClass, Object code) {
        for (T enumConstant : enumClass.getEnumConstants()) {
            if (enumConstant.codeObjEquals(code)) {
                return enumConstant;
            }
        }

        return null;
    }

    /**
     * 获取枚举code
     *
     * @return 枚举code
     */
    K getCode();

    /**
     * 获取枚举简体desc
     *
     * @return desc
     */
    String getDescZhCn();

    /**
     * 获取枚举繁体desc
     *
     * @return desc
     */
    String getDescZhTw();

    /**
     * 获取枚举英文desc
     *
     * @return desc
     */
    String getDescEnUs();

    default boolean codeObjEquals(Object compareCode) {
        if (compareCode == null) {
            return false;
        }

        K code = getCode();
        if (code.getClass().isInstance(compareCode)) {
            return code.equals(compareCode);
        } else {
            String compareCodeStr = StrUtil.toStringOrNull(compareCode);
            String codeStr = StrUtil.toStringOrNull(code);
            return Objects.equals(codeStr, compareCodeStr);
        }
    }

    default boolean codeEquals(K compareCode) {
        K code = getCode();
        return code.equals(compareCode);
    }

    default MultiLanguageDTO<String> buildMultiLangDto() {
        MultiLanguageDTO<String> multiLangDto = new MultiLanguageDTO<>();

        multiLangDto.setZh_CN(getDescZhCn());
        multiLangDto.setZh_TW(getDescZhTw());
        multiLangDto.setEn_US(getDescEnUs());

        return multiLangDto;
    }
}
