package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.athena.bo.assembly.RuntimeVariable;
import com.digiwin.athena.datacollect.expression.ExpressionResolver;
import com.digiwin.athena.dto.assembly.variable.VarDefMapNode;
import com.digiwin.athena.service.assembly.DVariableService;
import com.digiwin.athena.service.assembly.RVariableService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 设计器运行时变量查询服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RVariableServiceImpl implements RVariableService {
    public static final String KEY_ENV_BEAN = "bean_env";
    protected final DVariableService dVariableService;
    protected final ExpressionResolver expressionResolver;

    @Override
    public RuntimeVariable getRuntimeVar() {
        // TODO pzz 使用脚本动态组装运行时变量
        return RuntimeVariable.capture();
    }

    @Override
    public Map<String, Object> getRuntimeVarMap(String varDefKey) {
        VarDefMapNode varDef = dVariableService.resolveVarDef(varDefKey);
        if (varDef == null) {
            return Collections.emptyMap();
        }

        Map<String, Object> contextMap = buildContextMap();
        var beanAccessor = ExpressionResolver.BeanAccessor.<VarDefMapNode>create()
                .addMapping(
                        VarDefMapNode.class,
                        VarDefMapNode::getValEvalExpr,
                        VarDefMapNode::setValEvalRet,
                        VarDefMapNode::getChildren
                );

        VarDefMapNode resolved = expressionResolver.resolve(varDef, contextMap, beanAccessor);
        return resolved.toMap();
    }

    protected Map<String, Object> buildContextMap() {
        Map<String, Object> contextMap = new HashMap<>(BeanUtil.beanToMap(getRuntimeVar()));
        contextMap.put(KEY_ENV_BEAN, SpringUtil.getBean(Environment.class));
        return contextMap;
    }
}
