package com.digiwin.athena.constants.enums.assembly;

import com.digiwin.athena.constants.enums.BaseLangEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 上线状态枚举
 */
@Getter
@AllArgsConstructor
public enum OnlineState implements BaseLangEnum<String> {
    /**
     * 草稿
     */
    Draft("draft", "草稿", "草稿", "Draft"),
    /**
     * 未上架
     */
    Offline("offline", "未上架", "未上架", "Offline"),
    /**
     * 已上架
     */
    Online("online", "已上架", "已上架", "Online");

    private final String code;
    private final String descZhCn;
    private final String descZhTw;
    private final String descEnUs;

    public static List<String> publishedCode() {
        return Arrays.asList(OnlineState.Online.getCode(), OnlineState.Offline.getCode());
    }

    public static boolean isOff(String status) {
        return !Online.getCode().equals(status);
    }
}
