package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.solution.RSolutionPlanPageQo;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.service.assembly.RSolutionPlanService;
import jakarta.validation.constraints.NotBlank;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 解决方案运行时
 */
@Slf4j
@RestController
@RequestMapping("/assembly/solutionPlan/r/")
@RequiredArgsConstructor
public class RSolutionPlanController {

    private final RSolutionPlanService rSolutionPlanService;

    /**
     * 列表
     */
    @PostMapping("/list")
    public ResultDto<Pagination<SolutionPlanListDTO>> list(@RequestBody PageReqCondition<RSolutionPlanPageQo> pageReqCondition) {
        log.debug("收到分页查询在线状态解决方案列表请求");
        Pagination<SolutionPlanListDTO> result = rSolutionPlanService.list(pageReqCondition);
        return ResultDto.createSuccess(result);
    }


    /**
     * 详情
     */
    @GetMapping("/{id}")
    public ResultDto<SolutionPlanDetailDTO> getDesignTimeAssemblyApplicationConfigDetail(@NotBlank @PathVariable String id) {
        log.debug("收到获取运行时态解决方案详情请求: {}", id);
        return ResultDto.createSuccess(rSolutionPlanService.findDetailById(id));
    }
}
