package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.datacollect.api.dto.AssetCollectApiResponse;
import com.digiwin.athena.mongodb.domain.application.Asset;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

/**
 * 资产对象转换器
 */
@Mapper(uses = BaseConverter.class)
public interface AssetConverter {
    AssetConverter INSTANCE = Mappers.getMapper(AssetConverter.class);

    /**
     * 合并Asset对象,只更新非空字段
     *
     * @param source 源对象(新数据)
     * @param target 目标对象(已存在的数据)
     */
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void merge(Asset source, @MappingTarget Asset target);
}
