package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Slf4j
@Repository
@RequiredArgsConstructor
@Deprecated
public class RAssetDefinitionMongoDao {

    private final MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;


    public void insert(AssetDefinition assetDefinition) {
        mongoRuntimeRepositoryDecorator.insert(assetDefinition);
    }

    public void deleteByAssetId(String assetId) {
        mongoRuntimeRepositoryDecorator.delete(new Query(Criteria.where("assetId").is(assetId)), AssetDefinition.class);
    }

    public void deleteByApplication(String appCode) {
        mongoRuntimeRepositoryDecorator.delete(new Query(Criteria.where("manageContext.application").is(appCode)), AssetDefinition.class);
    }
}
