package com.digiwin.athena.publish;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dao.mongodao.asset.AssetDefinitionMongoDao;
import com.digiwin.athena.dao.mongodao.asset.AssetMongoDao;
import com.digiwin.athena.dao.mongodao.asset.RAssetDefinitionMongoDao;
import com.digiwin.athena.dao.mongodao.asset.RAssetMongoDao;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.dto.asset.AssetBusinessDto;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.publish.dto.PublishParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@Slf4j
@Order(400)
@RequiredArgsConstructor
@Deprecated
public class AssetPublish extends Publish<AssetBusinessDto> {

    private final AssetMongoDao assetMongoDao;
    private final RAssetMongoDao rAssetMongoDao;
    private final AssetDefinitionMongoDao assetDefinitionMongoDao;
    private final RAssetDefinitionMongoDao rAssetDefinitionMongoDao;


    @Override
    public List<AssetBusinessDto> doCompile(List<AssetBusinessDto> data) {
        return data;
    }

    @Override
    public List<AssetBusinessDto> findAllPublishData(PublishParam publishParam) {
        List<AssetBusinessDto> res = new ArrayList<>();
        List<AssetDefinition> assetDefinitions = assetDefinitionMongoDao.selectByApplication(publishParam.getApplication());
        if (assetDefinitions.isEmpty()){
            return res;
        }

        for (AssetDefinition assetDefinition : assetDefinitions) {
            AssetBusinessDto assetBusinessDto = new AssetBusinessDto();
            assetBusinessDto.setAssetDefinition(assetDefinition);
            List<Asset> assets = assetMongoDao.selectByAssetId(assetDefinition.getAssetId());
            assetBusinessDto.setAssetList(assets);

            res.add(assetBusinessDto);
        }

        return res;
    }

    @Override
    void deleteRuntimeData(DeployDataDto<AssetBusinessDto> deployDataDto) {

    }

    @Override
    void insertSingleRuntimeData(AssetBusinessDto publishData) {
        AssetDefinition assetDefinition = publishData.getAssetDefinition();
        if (assetDefinition!=null){
            rAssetDefinitionMongoDao.insert(assetDefinition);
        }
        List<Asset> assetList = publishData.getAssetList();
        if (!CollectionUtils.isEmpty(assetList)){
            rAssetMongoDao.insertAll(assetList);
        }
    }

    @Override
    void deleteSingleRuntimeData(AssetBusinessDto publishData) {
        List<Asset> assetList = publishData.getAssetList();
        rAssetMongoDao.deleteByObjIds(assetList.stream().map(a->a.getObjectId()).collect(Collectors.toList()));

        AssetDefinition assetDefinition = publishData.getAssetDefinition();
        rAssetDefinitionMongoDao.deleteByAssetId(assetDefinition.getAssetId());
    }

    @Override
    public List<AssetBusinessDto> jsonStrToObject(String jsonStr) {
        return JSONObject.parseArray(jsonStr,AssetBusinessDto.class);
    }
}
