/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datacollect.context;

import com.digiwin.athena.config.AssemblyProp;
import com.digiwin.athena.convertor.assembly.DataCollectorConverter;
import com.digiwin.athena.datacollect.model.CollectExecutorProp;
import com.digiwin.athena.datacollect.model.JobExecData;
import com.digiwin.athena.mongodb.domain.DataCollectConfig;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectContext.class);
    private String assetTypeId;
    private AssetType assetType;
    private LocalDateTime fireTime;
    private DataCollectConfig config;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Integer pageNo;
    private Integer pageSize;
    private Duration stepDuration;
    private Map<String, Object> loopParam;
    private Integer loopIndex;
    private LocalDateTime currentStepStartTime;
    private LocalDateTime currentStepEndTime;
    private Integer consumedRecords;
    private Integer totalSteps;
    private Integer totalPages;
    private Integer totalRecords;

    public void init(int pageSize) {
        this.pageNo = 1;
        this.pageSize = pageSize;
        this.loopIndex = 0;
        this.totalSteps = 0;
        this.totalPages = 0;
        this.totalRecords = 0;
        this.consumedRecords = 0;
    }

    public void begin() {
        LocalDateTime currentStepStart = this.currentStepStartTime;
        if (currentStepStart == null) {
            this.currentStepStartTime = currentStepStart = this.startTime;
            this.currentStepEndTime = this.calculateStepEndTime(currentStepStart);
        }
        if (this.loopIndex == null) {
            this.loopIndex = 0;
        }
    }

    public static CollectContext buildCollectContext(DataCollectConfig config, AssemblyProp.DataCollector collectorProp, AssetType assetType, JobExecData presetExecData, LocalDateTime fireTime) {
        CollectExecutorProp executor = config.getExecutor();
        CollectContext context = new CollectContext();
        context.setAssetTypeId(assetType.getObjId());
        context.setAssetType(assetType);
        context.setConfig(config);
        context.setStepDuration(executor.getStepDuration(collectorProp));
        context.init(executor.getPageSize(collectorProp));
        if (presetExecData != null) {
            DataCollectorConverter.INSTANCE.merge(presetExecData, context);
            log.info("\u7eed\u67e5\u4efb\u52a1:  assetTypeKey={}, context:{}", (Object)assetType.getKey(), (Object)context);
        } else {
            context.setStartTime(executor.getStartTime(collectorProp));
            log.info("\u9996\u6b21\u6267\u884c\u4efb\u52a1: assetTypeKey={}, startTime={}", (Object)assetType.getKey(), (Object)context.getStartTime());
        }
        if (context.getEndTime() == null) {
            context.setEndTime(fireTime);
        }
        context.setFireTime(fireTime);
        return context;
    }

    public void step() {
        Integer n = this.totalSteps;
        this.totalSteps = this.totalSteps + 1;
        this.pageNo = 1;
        this.loopIndex = 0;
        this.loopParam = null;
        this.currentStepStartTime = this.currentStepEndTime;
        this.currentStepEndTime = this.calculateStepEndTime(this.currentStepStartTime);
    }

    public void incrementPageNo() {
        Integer n = this.pageNo;
        this.pageNo = this.pageNo + 1;
    }

    public void addRecords(int fetchedCount, int consumedCount) {
        this.totalRecords = this.totalRecords + fetchedCount;
        this.consumedRecords = this.consumedRecords + consumedCount;
        Integer n = this.totalPages;
        this.totalPages = this.totalPages + 1;
    }

    public String getOpFromLoopParam() {
        if (this.loopParam != null && this.loopParam.containsKey("op")) {
            Object op = this.loopParam.get("op");
            return op != null ? op.toString() : "upsert";
        }
        return "upsert";
    }

    public boolean hasNext() {
        if (this.currentStepStartTime == null) {
            return this.currentStepEndTime.isBefore(this.endTime) || this.currentStepEndTime.isEqual(this.endTime);
        }
        return this.currentStepStartTime.isBefore(this.endTime);
    }

    public LocalDateTime calculateStepEndTime(LocalDateTime stepStart) {
        LocalDateTime finalEndTime = this.getEndTime();
        if (stepStart == null || this.stepDuration == null || this.stepDuration.getSeconds() <= 0L) {
            return finalEndTime;
        }
        LocalDateTime stepEnd = stepStart.plusMinutes(this.stepDuration.toMinutes());
        return stepEnd.isBefore(finalEndTime) ? stepEnd : finalEndTime;
    }

    @Generated
    public CollectContext() {
    }

    @Generated
    public String getAssetTypeId() {
        return this.assetTypeId;
    }

    @Generated
    public AssetType getAssetType() {
        return this.assetType;
    }

    @Generated
    public LocalDateTime getFireTime() {
        return this.fireTime;
    }

    @Generated
    public DataCollectConfig getConfig() {
        return this.config;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public Integer getPageNo() {
        return this.pageNo;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Duration getStepDuration() {
        return this.stepDuration;
    }

    @Generated
    public Map<String, Object> getLoopParam() {
        return this.loopParam;
    }

    @Generated
    public Integer getLoopIndex() {
        return this.loopIndex;
    }

    @Generated
    public LocalDateTime getCurrentStepStartTime() {
        return this.currentStepStartTime;
    }

    @Generated
    public LocalDateTime getCurrentStepEndTime() {
        return this.currentStepEndTime;
    }

    @Generated
    public Integer getConsumedRecords() {
        return this.consumedRecords;
    }

    @Generated
    public Integer getTotalSteps() {
        return this.totalSteps;
    }

    @Generated
    public Integer getTotalPages() {
        return this.totalPages;
    }

    @Generated
    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    @Generated
    public void setAssetTypeId(String assetTypeId) {
        this.assetTypeId = assetTypeId;
    }

    @Generated
    public void setAssetType(AssetType assetType) {
        this.assetType = assetType;
    }

    @Generated
    public void setFireTime(LocalDateTime fireTime) {
        this.fireTime = fireTime;
    }

    @Generated
    public void setConfig(DataCollectConfig config) {
        this.config = config;
    }

    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setStepDuration(Duration stepDuration) {
        this.stepDuration = stepDuration;
    }

    @Generated
    public void setLoopParam(Map<String, Object> loopParam) {
        this.loopParam = loopParam;
    }

    @Generated
    public void setLoopIndex(Integer loopIndex) {
        this.loopIndex = loopIndex;
    }

    @Generated
    public void setCurrentStepStartTime(LocalDateTime currentStepStartTime) {
        this.currentStepStartTime = currentStepStartTime;
    }

    @Generated
    public void setCurrentStepEndTime(LocalDateTime currentStepEndTime) {
        this.currentStepEndTime = currentStepEndTime;
    }

    @Generated
    public void setConsumedRecords(Integer consumedRecords) {
        this.consumedRecords = consumedRecords;
    }

    @Generated
    public void setTotalSteps(Integer totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Generated
    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    @Generated
    public void setTotalRecords(Integer totalRecords) {
        this.totalRecords = totalRecords;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectContext)) {
            return false;
        }
        CollectContext other = (CollectContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$loopIndex = this.getLoopIndex();
        Integer other$loopIndex = other.getLoopIndex();
        if (this$loopIndex == null ? other$loopIndex != null : !((Object)this$loopIndex).equals(other$loopIndex)) {
            return false;
        }
        Integer this$consumedRecords = this.getConsumedRecords();
        Integer other$consumedRecords = other.getConsumedRecords();
        if (this$consumedRecords == null ? other$consumedRecords != null : !((Object)this$consumedRecords).equals(other$consumedRecords)) {
            return false;
        }
        Integer this$totalSteps = this.getTotalSteps();
        Integer other$totalSteps = other.getTotalSteps();
        if (this$totalSteps == null ? other$totalSteps != null : !((Object)this$totalSteps).equals(other$totalSteps)) {
            return false;
        }
        Integer this$totalPages = this.getTotalPages();
        Integer other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !((Object)this$totalPages).equals(other$totalPages)) {
            return false;
        }
        Integer this$totalRecords = this.getTotalRecords();
        Integer other$totalRecords = other.getTotalRecords();
        if (this$totalRecords == null ? other$totalRecords != null : !((Object)this$totalRecords).equals(other$totalRecords)) {
            return false;
        }
        String this$assetTypeId = this.getAssetTypeId();
        String other$assetTypeId = other.getAssetTypeId();
        if (this$assetTypeId == null ? other$assetTypeId != null : !this$assetTypeId.equals(other$assetTypeId)) {
            return false;
        }
        AssetType this$assetType = this.getAssetType();
        AssetType other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !((Object)this$assetType).equals(other$assetType)) {
            return false;
        }
        LocalDateTime this$fireTime = this.getFireTime();
        LocalDateTime other$fireTime = other.getFireTime();
        if (this$fireTime == null ? other$fireTime != null : !((Object)this$fireTime).equals(other$fireTime)) {
            return false;
        }
        DataCollectConfig this$config = this.getConfig();
        DataCollectConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Duration this$stepDuration = this.getStepDuration();
        Duration other$stepDuration = other.getStepDuration();
        if (this$stepDuration == null ? other$stepDuration != null : !((Object)this$stepDuration).equals(other$stepDuration)) {
            return false;
        }
        Map<String, Object> this$loopParam = this.getLoopParam();
        Map<String, Object> other$loopParam = other.getLoopParam();
        if (this$loopParam == null ? other$loopParam != null : !((Object)this$loopParam).equals(other$loopParam)) {
            return false;
        }
        LocalDateTime this$currentStepStartTime = this.getCurrentStepStartTime();
        LocalDateTime other$currentStepStartTime = other.getCurrentStepStartTime();
        if (this$currentStepStartTime == null ? other$currentStepStartTime != null : !((Object)this$currentStepStartTime).equals(other$currentStepStartTime)) {
            return false;
        }
        LocalDateTime this$currentStepEndTime = this.getCurrentStepEndTime();
        LocalDateTime other$currentStepEndTime = other.getCurrentStepEndTime();
        return !(this$currentStepEndTime == null ? other$currentStepEndTime != null : !((Object)this$currentStepEndTime).equals(other$currentStepEndTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $loopIndex = this.getLoopIndex();
        result = result * 59 + ($loopIndex == null ? 43 : ((Object)$loopIndex).hashCode());
        Integer $consumedRecords = this.getConsumedRecords();
        result = result * 59 + ($consumedRecords == null ? 43 : ((Object)$consumedRecords).hashCode());
        Integer $totalSteps = this.getTotalSteps();
        result = result * 59 + ($totalSteps == null ? 43 : ((Object)$totalSteps).hashCode());
        Integer $totalPages = this.getTotalPages();
        result = result * 59 + ($totalPages == null ? 43 : ((Object)$totalPages).hashCode());
        Integer $totalRecords = this.getTotalRecords();
        result = result * 59 + ($totalRecords == null ? 43 : ((Object)$totalRecords).hashCode());
        String $assetTypeId = this.getAssetTypeId();
        result = result * 59 + ($assetTypeId == null ? 43 : $assetTypeId.hashCode());
        AssetType $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : ((Object)$assetType).hashCode());
        LocalDateTime $fireTime = this.getFireTime();
        result = result * 59 + ($fireTime == null ? 43 : ((Object)$fireTime).hashCode());
        DataCollectConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Duration $stepDuration = this.getStepDuration();
        result = result * 59 + ($stepDuration == null ? 43 : ((Object)$stepDuration).hashCode());
        Map<String, Object> $loopParam = this.getLoopParam();
        result = result * 59 + ($loopParam == null ? 43 : ((Object)$loopParam).hashCode());
        LocalDateTime $currentStepStartTime = this.getCurrentStepStartTime();
        result = result * 59 + ($currentStepStartTime == null ? 43 : ((Object)$currentStepStartTime).hashCode());
        LocalDateTime $currentStepEndTime = this.getCurrentStepEndTime();
        result = result * 59 + ($currentStepEndTime == null ? 43 : ((Object)$currentStepEndTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectContext(assetTypeId=" + this.getAssetTypeId() + ", assetType=" + String.valueOf(this.getAssetType()) + ", fireTime=" + String.valueOf(this.getFireTime()) + ", config=" + String.valueOf(this.getConfig()) + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", stepDuration=" + String.valueOf(this.getStepDuration()) + ", loopParam=" + String.valueOf(this.getLoopParam()) + ", loopIndex=" + this.getLoopIndex() + ", currentStepStartTime=" + String.valueOf(this.getCurrentStepStartTime()) + ", currentStepEndTime=" + String.valueOf(this.getCurrentStepEndTime()) + ", consumedRecords=" + this.getConsumedRecords() + ", totalSteps=" + this.getTotalSteps() + ", totalPages=" + this.getTotalPages() + ", totalRecords=" + this.getTotalRecords() + ")";
    }
}

