package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.mongodb.domain.application.ApplicationConfig;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

import java.util.List;

import static org.mapstruct.ReportingPolicy.IGNORE;


/**
 * 解决方案配置对象转换器
 */
@Mapper(uses = {BaseConverter.class})
public interface SolutionConvertor {
    SolutionConvertor INSTANCE = Mappers.getMapper(SolutionConvertor.class);

    SolutionPlan toBO(ApplicationConfig entity);

    @InheritInverseConfiguration
    @BeanMapping(unmappedTargetPolicy = IGNORE)
    ApplicationConfig toEntity(SolutionPlan solution);

    @Mapping(target = "lang", qualifiedByName = "shallowMap")
    SolutionPlanListDTO entityToListDTO(ApplicationConfig bo);

    List<SolutionPlanListDTO> entitySetToListDTO(List<ApplicationConfig> bo);

    @BeanMapping(unmappedTargetPolicy = IGNORE)
    SolutionPlan toBo(SolutionPlanSaveDTO designer);

    SolutionPlanDetailDTO toDto(SolutionPlan solutionPlan);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void merge(SolutionPlan source, @MappingTarget SolutionPlan target);

    @AfterMapping
    default void translateDetail(@MappingTarget SolutionPlanDetailDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    @AfterMapping
    default void translateList(@MappingTarget SolutionPlanListDTO dto) {
        BaseConverter.INSTANCE.translateDictField(dto);
    }

    SolutionPlanBaseDTO toBaseDTO(SolutionPlanListDTO solutionPlan);

    List<SolutionPlanBaseDTO> toBaseDTO(List<SolutionPlanListDTO> solutionPlan);

    SolutionPlanDetailDTO.AppCallBackDTO toDto(ApplicationConfig.AppCallBack entity);

    ApplicationConfig.AppCallBack toEntity(SolutionPlanDetailDTO.AppCallBackDTO dto);

}
