package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.bo.assembly.SolutionPlan;
import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanListDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanSaveDTO;
import com.digiwin.athena.mongodb.domain.application.ApplicationConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-17T12:04:07+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
public class SolutionConvertorImpl implements SolutionConvertor {

    private final BaseConverter baseConverter = Mappers.getMapper( BaseConverter.class );

    @Override
    public SolutionPlan toBO(ApplicationConfig entity) {
        if ( entity == null ) {
            return null;
        }

        SolutionPlan solutionPlan = new SolutionPlan();

        solutionPlan.setPublishTime( baseConverter.localDateTime2Date( entity.getPublishTime() ) );
        solutionPlan.setId( entity.getId() );
        solutionPlan.setType( entity.getType() );
        solutionPlan.setName( entity.getName() );
        solutionPlan.setVersion( entity.getVersion() );
        solutionPlan.setVersionSort( entity.getVersionSort() );
        solutionPlan.setDescription( entity.getDescription() );
        solutionPlan.setAssemblyType( entity.getAssemblyType() );
        solutionPlan.setStatus( entity.getStatus() );
        solutionPlan.setOwner( entity.getOwner() );
        solutionPlan.setCategory( entity.getCategory() );
        solutionPlan.setAppType( entity.getAppType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = entity.getDesignerList();
        if ( list != null ) {
            solutionPlan.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        solutionPlan.setFrontBizSetupPageIdx( entity.getFrontBizSetupPageIdx() );
        Map<String, Object> map = entity.getCanvas();
        if ( map != null ) {
            solutionPlan.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlan.setLayoutMode( entity.getLayoutMode() );
        solutionPlan.setSsoConfig( entity.getSsoConfig() );
        solutionPlan.setAppCreateCallback( appCallBackListToAppCallBackDTOList( entity.getAppCreateCallback() ) );
        solutionPlan.setAppUpdateCallback( appCallBackListToAppCallBackDTOList( entity.getAppUpdateCallback() ) );
        solutionPlan.setCompile( appCallBackListToAppCallBackDTOList( entity.getCompile() ) );
        solutionPlan.setPublish( appCallBackListToAppCallBackDTOList( entity.getPublish() ) );
        solutionPlan.setIsStdPublish( entity.getIsStdPublish() );
        Map<String, Object> map1 = entity.getMergeJson();
        if ( map1 != null ) {
            solutionPlan.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = entity.getLang();
        if ( map2 != null ) {
            solutionPlan.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }
        solutionPlan.setPublishBy( entity.getPublishBy() );
        solutionPlan.setCreateTime( entity.getCreateTime() );
        solutionPlan.setEditTime( entity.getEditTime() );
        solutionPlan.setCreateBy( entity.getCreateBy() );
        solutionPlan.setEditBy( entity.getEditBy() );

        return solutionPlan;
    }

    @Override
    public ApplicationConfig toEntity(SolutionPlan solution) {
        if ( solution == null ) {
            return null;
        }

        ApplicationConfig applicationConfig = new ApplicationConfig();

        applicationConfig.setId( solution.getId() );
        applicationConfig.setType( solution.getType() );
        applicationConfig.setAppType( solution.getAppType() );
        applicationConfig.setName( solution.getName() );
        applicationConfig.setVersion( solution.getVersion() );
        applicationConfig.setVersionSort( solution.getVersionSort() );
        applicationConfig.setDescription( solution.getDescription() );
        applicationConfig.setAssemblyType( solution.getAssemblyType() );
        applicationConfig.setStatus( solution.getStatus() );
        applicationConfig.setOwner( solution.getOwner() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = solution.getDesignerList();
        if ( list != null ) {
            applicationConfig.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = solution.getCanvas();
        if ( map != null ) {
            applicationConfig.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        applicationConfig.setLayoutMode( solution.getLayoutMode() );
        applicationConfig.setSsoConfig( solution.getSsoConfig() );
        applicationConfig.setCategory( solution.getCategory() );
        applicationConfig.setAppCreateCallback( appCallBackDTOListToAppCallBackList( solution.getAppCreateCallback() ) );
        applicationConfig.setAppUpdateCallback( appCallBackDTOListToAppCallBackList( solution.getAppUpdateCallback() ) );
        applicationConfig.setCompile( appCallBackDTOListToAppCallBackList( solution.getCompile() ) );
        applicationConfig.setPublish( appCallBackDTOListToAppCallBackList( solution.getPublish() ) );
        applicationConfig.setIsStdPublish( solution.getIsStdPublish() );
        applicationConfig.setFrontBizSetupPageIdx( solution.getFrontBizSetupPageIdx() );
        Map<String, MultiLanguageDTO<String>> map1 = solution.getLang();
        if ( map1 != null ) {
            applicationConfig.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map1 ) );
        }
        Map<String, Object> map2 = solution.getMergeJson();
        if ( map2 != null ) {
            applicationConfig.setMergeJson( new LinkedHashMap<String, Object>( map2 ) );
        }
        applicationConfig.setPublishTime( baseConverter.date2LocalDateTime( solution.getPublishTime() ) );
        applicationConfig.setPublishBy( solution.getPublishBy() );
        applicationConfig.setCreateTime( solution.getCreateTime() );
        applicationConfig.setEditTime( solution.getEditTime() );
        applicationConfig.setCreateBy( solution.getCreateBy() );
        applicationConfig.setEditBy( solution.getEditBy() );

        return applicationConfig;
    }

    @Override
    public SolutionPlanListDTO entityToListDTO(ApplicationConfig bo) {
        if ( bo == null ) {
            return null;
        }

        SolutionPlanListDTO solutionPlanListDTO = new SolutionPlanListDTO();

        solutionPlanListDTO.setLang( baseConverter.shallowMap( bo.getLang() ) );
        solutionPlanListDTO.setId( bo.getId() );
        solutionPlanListDTO.setName( bo.getName() );
        solutionPlanListDTO.setType( bo.getType() );
        solutionPlanListDTO.setCategory( baseConverter.toInt( bo.getCategory() ) );
        solutionPlanListDTO.setAppType( bo.getAppType() );
        solutionPlanListDTO.setAssemblyType( bo.getAssemblyType() );
        solutionPlanListDTO.setSsoConfig( bo.getSsoConfig() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = bo.getDesignerList();
        if ( list != null ) {
            solutionPlanListDTO.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        solutionPlanListDTO.setOwner( bo.getOwner() );
        solutionPlanListDTO.setStatus( bo.getStatus() );
        solutionPlanListDTO.setVersion( bo.getVersion() );
        solutionPlanListDTO.setIsStdPublish( bo.getIsStdPublish() );
        solutionPlanListDTO.setPopularSort( bo.getPopularSort() );
        solutionPlanListDTO.setFrontBizSetupPageIdx( bo.getFrontBizSetupPageIdx() );
        solutionPlanListDTO.setPublishTime( bo.getPublishTime() );
        solutionPlanListDTO.setPublishBy( bo.getPublishBy() );
        solutionPlanListDTO.setCreateTime( bo.getCreateTime() );
        solutionPlanListDTO.setCreateBy( bo.getCreateBy() );
        solutionPlanListDTO.setEditTime( bo.getEditTime() );
        solutionPlanListDTO.setEditBy( bo.getEditBy() );

        translateList( solutionPlanListDTO );

        return solutionPlanListDTO;
    }

    @Override
    public List<SolutionPlanListDTO> entitySetToListDTO(List<ApplicationConfig> bo) {
        if ( bo == null ) {
            return null;
        }

        List<SolutionPlanListDTO> list = new ArrayList<SolutionPlanListDTO>( bo.size() );
        for ( ApplicationConfig applicationConfig : bo ) {
            list.add( entityToListDTO( applicationConfig ) );
        }

        return list;
    }

    @Override
    public SolutionPlan toBo(SolutionPlanSaveDTO designer) {
        if ( designer == null ) {
            return null;
        }

        SolutionPlan solutionPlan = new SolutionPlan();

        solutionPlan.setId( designer.getId() );
        solutionPlan.setType( designer.getType() );
        solutionPlan.setName( designer.getName() );
        solutionPlan.setVersion( designer.getVersion() );
        solutionPlan.setDescription( designer.getDescription() );
        solutionPlan.setAssemblyType( designer.getAssemblyType() );
        solutionPlan.setOwner( designer.getOwner() );
        if ( designer.getCategory() != null ) {
            solutionPlan.setCategory( String.valueOf( designer.getCategory() ) );
        }
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = designer.getDesignerList();
        if ( list != null ) {
            solutionPlan.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        solutionPlan.setFrontBizSetupPageIdx( designer.getFrontBizSetupPageIdx() );
        Map<String, Object> map = designer.getCanvas();
        if ( map != null ) {
            solutionPlan.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlan.setLayoutMode( designer.getLayoutMode() );
        solutionPlan.setSsoConfig( designer.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = designer.getAppCreateCallback();
        if ( list1 != null ) {
            solutionPlan.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = designer.getAppUpdateCallback();
        if ( list2 != null ) {
            solutionPlan.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = designer.getCompile();
        if ( list3 != null ) {
            solutionPlan.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = designer.getPublish();
        if ( list4 != null ) {
            solutionPlan.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        solutionPlan.setIsStdPublish( designer.getIsStdPublish() );
        Map<String, Object> map1 = designer.getMergeJson();
        if ( map1 != null ) {
            solutionPlan.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = designer.getLang();
        if ( map2 != null ) {
            solutionPlan.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }

        return solutionPlan;
    }

    @Override
    public SolutionPlanDetailDTO toDto(SolutionPlan solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        SolutionPlanDetailDTO solutionPlanDetailDTO = new SolutionPlanDetailDTO();

        solutionPlanDetailDTO.setId( solutionPlan.getId() );
        solutionPlanDetailDTO.setType( solutionPlan.getType() );
        solutionPlanDetailDTO.setName( solutionPlan.getName() );
        solutionPlanDetailDTO.setVersion( solutionPlan.getVersion() );
        solutionPlanDetailDTO.setDescription( solutionPlan.getDescription() );
        solutionPlanDetailDTO.setAssemblyType( solutionPlan.getAssemblyType() );
        solutionPlanDetailDTO.setStatus( solutionPlan.getStatus() );
        solutionPlanDetailDTO.setOwner( solutionPlan.getOwner() );
        solutionPlanDetailDTO.setCategory( baseConverter.toInt( solutionPlan.getCategory() ) );
        solutionPlanDetailDTO.setAppType( solutionPlan.getAppType() );
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = solutionPlan.getDesignerList();
        if ( list != null ) {
            solutionPlanDetailDTO.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
        }
        Map<String, Object> map = solutionPlan.getCanvas();
        if ( map != null ) {
            solutionPlanDetailDTO.setCanvas( new LinkedHashMap<String, Object>( map ) );
        }
        solutionPlanDetailDTO.setLayoutMode( solutionPlan.getLayoutMode() );
        solutionPlanDetailDTO.setSsoConfig( solutionPlan.getSsoConfig() );
        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = solutionPlan.getAppCreateCallback();
        if ( list1 != null ) {
            solutionPlanDetailDTO.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = solutionPlan.getAppUpdateCallback();
        if ( list2 != null ) {
            solutionPlanDetailDTO.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = solutionPlan.getCompile();
        if ( list3 != null ) {
            solutionPlanDetailDTO.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = solutionPlan.getPublish();
        if ( list4 != null ) {
            solutionPlanDetailDTO.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
        }
        solutionPlanDetailDTO.setFrontBizSetupPageIdx( solutionPlan.getFrontBizSetupPageIdx() );
        solutionPlanDetailDTO.setIsStdPublish( solutionPlan.getIsStdPublish() );
        Map<String, Object> map1 = solutionPlan.getMergeJson();
        if ( map1 != null ) {
            solutionPlanDetailDTO.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
        }
        Map<String, MultiLanguageDTO<String>> map2 = solutionPlan.getLang();
        if ( map2 != null ) {
            solutionPlanDetailDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
        }
        solutionPlanDetailDTO.setPublishTime( baseConverter.date2LocalDateTime( solutionPlan.getPublishTime() ) );
        solutionPlanDetailDTO.setPublishBy( solutionPlan.getPublishBy() );
        solutionPlanDetailDTO.setCreateTime( solutionPlan.getCreateTime() );
        solutionPlanDetailDTO.setEditTime( solutionPlan.getEditTime() );
        solutionPlanDetailDTO.setCreateBy( solutionPlan.getCreateBy() );
        solutionPlanDetailDTO.setEditBy( solutionPlan.getEditBy() );

        translateDetail( solutionPlanDetailDTO );

        return solutionPlanDetailDTO;
    }

    @Override
    public void merge(SolutionPlan source, SolutionPlan target) {
        if ( source == null ) {
            return;
        }

        if ( source.getPublishTime() != null ) {
            target.setPublishTime( source.getPublishTime() );
        }
        if ( source.getId() != null ) {
            target.setId( source.getId() );
        }
        if ( source.getType() != null ) {
            target.setType( source.getType() );
        }
        if ( source.getName() != null ) {
            target.setName( source.getName() );
        }
        if ( source.getVersion() != null ) {
            target.setVersion( source.getVersion() );
        }
        if ( source.getVersionSort() != null ) {
            target.setVersionSort( source.getVersionSort() );
        }
        if ( source.getDescription() != null ) {
            target.setDescription( source.getDescription() );
        }
        if ( source.getAssemblyType() != null ) {
            target.setAssemblyType( source.getAssemblyType() );
        }
        if ( source.getStatus() != null ) {
            target.setStatus( source.getStatus() );
        }
        if ( source.getOwner() != null ) {
            target.setOwner( source.getOwner() );
        }
        if ( source.getCategory() != null ) {
            target.setCategory( source.getCategory() );
        }
        if ( source.getAppType() != null ) {
            target.setAppType( source.getAppType() );
        }
        if ( target.getDesignerList() != null ) {
            List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = source.getDesignerList();
            if ( list != null ) {
                target.getDesignerList().clear();
                target.getDesignerList().addAll( list );
            }
        }
        else {
            List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> list = source.getDesignerList();
            if ( list != null ) {
                target.setDesignerList( new ArrayList<SolutionPlanDetailDTO.DesignerBaseInfoDTO>( list ) );
            }
        }
        if ( source.getFrontBizSetupPageIdx() != null ) {
            target.setFrontBizSetupPageIdx( source.getFrontBizSetupPageIdx() );
        }
        if ( target.getCanvas() != null ) {
            Map<String, Object> map = source.getCanvas();
            if ( map != null ) {
                target.getCanvas().clear();
                target.getCanvas().putAll( map );
            }
        }
        else {
            Map<String, Object> map = source.getCanvas();
            if ( map != null ) {
                target.setCanvas( new LinkedHashMap<String, Object>( map ) );
            }
        }
        if ( source.getLayoutMode() != null ) {
            target.setLayoutMode( source.getLayoutMode() );
        }
        if ( source.getSsoConfig() != null ) {
            target.setSsoConfig( source.getSsoConfig() );
        }
        if ( target.getAppCreateCallback() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = source.getAppCreateCallback();
            if ( list1 != null ) {
                target.getAppCreateCallback().clear();
                target.getAppCreateCallback().addAll( list1 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = source.getAppCreateCallback();
            if ( list1 != null ) {
                target.setAppCreateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list1 ) );
            }
        }
        if ( target.getAppUpdateCallback() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = source.getAppUpdateCallback();
            if ( list2 != null ) {
                target.getAppUpdateCallback().clear();
                target.getAppUpdateCallback().addAll( list2 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list2 = source.getAppUpdateCallback();
            if ( list2 != null ) {
                target.setAppUpdateCallback( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list2 ) );
            }
        }
        if ( target.getCompile() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = source.getCompile();
            if ( list3 != null ) {
                target.getCompile().clear();
                target.getCompile().addAll( list3 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list3 = source.getCompile();
            if ( list3 != null ) {
                target.setCompile( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list3 ) );
            }
        }
        if ( target.getPublish() != null ) {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = source.getPublish();
            if ( list4 != null ) {
                target.getPublish().clear();
                target.getPublish().addAll( list4 );
            }
        }
        else {
            List<SolutionPlanDetailDTO.AppCallBackDTO> list4 = source.getPublish();
            if ( list4 != null ) {
                target.setPublish( new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list4 ) );
            }
        }
        if ( source.getIsStdPublish() != null ) {
            target.setIsStdPublish( source.getIsStdPublish() );
        }
        if ( target.getMergeJson() != null ) {
            Map<String, Object> map1 = source.getMergeJson();
            if ( map1 != null ) {
                target.getMergeJson().clear();
                target.getMergeJson().putAll( map1 );
            }
        }
        else {
            Map<String, Object> map1 = source.getMergeJson();
            if ( map1 != null ) {
                target.setMergeJson( new LinkedHashMap<String, Object>( map1 ) );
            }
        }
        if ( target.getLang() != null ) {
            Map<String, MultiLanguageDTO<String>> map2 = source.getLang();
            if ( map2 != null ) {
                target.getLang().clear();
                target.getLang().putAll( map2 );
            }
        }
        else {
            Map<String, MultiLanguageDTO<String>> map2 = source.getLang();
            if ( map2 != null ) {
                target.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map2 ) );
            }
        }
        if ( source.getPublishBy() != null ) {
            target.setPublishBy( source.getPublishBy() );
        }
        if ( source.getCreateTime() != null ) {
            target.setCreateTime( source.getCreateTime() );
        }
        if ( source.getEditTime() != null ) {
            target.setEditTime( source.getEditTime() );
        }
        if ( source.getCreateBy() != null ) {
            target.setCreateBy( source.getCreateBy() );
        }
        if ( source.getEditBy() != null ) {
            target.setEditBy( source.getEditBy() );
        }
    }

    @Override
    public SolutionPlanBaseDTO toBaseDTO(SolutionPlanListDTO solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        SolutionPlanBaseDTO solutionPlanBaseDTO = new SolutionPlanBaseDTO();

        solutionPlanBaseDTO.setId( solutionPlan.getId() );
        solutionPlanBaseDTO.setType( solutionPlan.getType() );
        solutionPlanBaseDTO.setName( solutionPlan.getName() );
        Map<String, MultiLanguageDTO<String>> map = solutionPlan.getLang();
        if ( map != null ) {
            solutionPlanBaseDTO.setLang( new LinkedHashMap<String, MultiLanguageDTO<String>>( map ) );
        }

        return solutionPlanBaseDTO;
    }

    @Override
    public List<SolutionPlanBaseDTO> toBaseDTO(List<SolutionPlanListDTO> solutionPlan) {
        if ( solutionPlan == null ) {
            return null;
        }

        List<SolutionPlanBaseDTO> list = new ArrayList<SolutionPlanBaseDTO>( solutionPlan.size() );
        for ( SolutionPlanListDTO solutionPlanListDTO : solutionPlan ) {
            list.add( toBaseDTO( solutionPlanListDTO ) );
        }

        return list;
    }

    @Override
    public SolutionPlanDetailDTO.AppCallBackDTO toDto(ApplicationConfig.AppCallBack entity) {
        if ( entity == null ) {
            return null;
        }

        SolutionPlanDetailDTO.AppCallBackDTO appCallBackDTO = new SolutionPlanDetailDTO.AppCallBackDTO();

        appCallBackDTO.setType( entity.getType() );
        appCallBackDTO.setUrl( entity.getUrl() );
        appCallBackDTO.setName( entity.getName() );
        appCallBackDTO.setMethod( entity.getMethod() );
        appCallBackDTO.setHeader( entity.getHeader() );
        appCallBackDTO.setScriptId( entity.getScriptId() );
        appCallBackDTO.setRequestScript( entity.getRequestScript() );
        appCallBackDTO.setResponseScript( entity.getResponseScript() );
        appCallBackDTO.setMethodName( entity.getMethodName() );

        return appCallBackDTO;
    }

    @Override
    public ApplicationConfig.AppCallBack toEntity(SolutionPlanDetailDTO.AppCallBackDTO dto) {
        if ( dto == null ) {
            return null;
        }

        ApplicationConfig.AppCallBack appCallBack = new ApplicationConfig.AppCallBack();

        appCallBack.setType( dto.getType() );
        appCallBack.setUrl( dto.getUrl() );
        appCallBack.setName( dto.getName() );
        appCallBack.setMethod( dto.getMethod() );
        appCallBack.setHeader( dto.getHeader() );
        appCallBack.setScriptId( dto.getScriptId() );
        appCallBack.setRequestScript( dto.getRequestScript() );
        appCallBack.setResponseScript( dto.getResponseScript() );
        appCallBack.setMethodName( dto.getMethodName() );

        return appCallBack;
    }

    protected List<SolutionPlanDetailDTO.AppCallBackDTO> appCallBackListToAppCallBackDTOList(List<ApplicationConfig.AppCallBack> list) {
        if ( list == null ) {
            return null;
        }

        List<SolutionPlanDetailDTO.AppCallBackDTO> list1 = new ArrayList<SolutionPlanDetailDTO.AppCallBackDTO>( list.size() );
        for ( ApplicationConfig.AppCallBack appCallBack : list ) {
            list1.add( toDto( appCallBack ) );
        }

        return list1;
    }

    protected List<ApplicationConfig.AppCallBack> appCallBackDTOListToAppCallBackList(List<SolutionPlanDetailDTO.AppCallBackDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<ApplicationConfig.AppCallBack> list1 = new ArrayList<ApplicationConfig.AppCallBack>( list.size() );
        for ( SolutionPlanDetailDTO.AppCallBackDTO appCallBackDTO : list ) {
            list1.add( toEntity( appCallBackDTO ) );
        }

        return list1;
    }
}
