/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bo.assembly;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.bo.assembly.IVersion;
import com.digiwin.athena.constants.AssemblyConstants;
import com.digiwin.athena.constants.enums.assembly.OnlineState;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanDetailDTO;
import com.digiwin.athena.mongodb.domain.PublishAble;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SolutionPlan
implements PublishAble,
IVersion {
    public static final int ASSEMBLY_BASE_APP_TYPE = 10000;
    private String id;
    private String type;
    private String name;
    private String version = "1.0";
    private Integer versionSort;
    private String description;
    private String assemblyType;
    private String status;
    private String owner;
    private String category;
    private Integer appType;
    private List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList;
    private Integer frontBizSetupPageIdx;
    private Map<String, Object> canvas;
    private String layoutMode;
    private SolutionPlanDetailDTO.SsoConfigDTO ssoConfig;
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appCreateCallback;
    private List<SolutionPlanDetailDTO.AppCallBackDTO> appUpdateCallback;
    private List<SolutionPlanDetailDTO.AppCallBackDTO> compile;
    private List<SolutionPlanDetailDTO.AppCallBackDTO> publish;
    private Boolean isStdPublish;
    private Map<String, Object> mergeJson;
    private Map<String, MultiLanguageDTO<String>> lang;
    private LocalDateTime publishTime;
    private String publishBy;
    private LocalDateTime createTime;
    private LocalDateTime editTime;
    private String createBy;
    private String editBy;

    public void overwriteUnmodifiable(SolutionPlan updated) {
        if (!OnlineState.Draft.getCode().equals(this.status)) {
            updated.setName(this.getName());
            updated.setType(this.getType());
        }
        updated.setStatus(this.getStatus());
        updated.setAppType(this.getAppType());
        updated.setCreateBy(this.getCreateBy());
        updated.setCreateTime(this.getCreateTime());
        updated.setPublishBy(this.getPublishBy());
        updated.setPublishTime(this.getPublishTime());
    }

    public void prepareNew() {
        this.setStatus(OnlineState.Draft.getCode());
        this.setPublishTime((LocalDateTime)null);
        this.setPublishBy(null);
    }

    public void checkUpdate(SolutionPlan exist) {
        if (!OnlineState.Draft.getCode().equals(exist.getStatus())) {
            throw new BusinessException(Integer.valueOf(30001), "\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\uff01", new Object[]{exist.getName(), exist.getStatus()});
        }
    }

    public void checkDelete(SolutionPlan exist) {
        if (!OnlineState.Draft.getCode().equals(exist.getStatus())) {
            throw new BusinessException(Integer.valueOf(30001), "\u72b6\u6001\u4e0d\u4e3a\u8349\u7a3f\uff01", new Object[]{exist.getName(), exist.getStatus()});
        }
    }

    public boolean isFirstPublish() {
        return this.getPublishTime() == null;
    }

    public void validateTypeFormat() {
        if (StrUtil.isBlank((CharSequence)this.type)) {
            throw new BusinessException(Integer.valueOf(30002), "\u89e3\u51b3\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!AssemblyConstants.TYPE_PATTERN.matcher(this.type).matches()) {
            throw new BusinessException(Integer.valueOf(30002), StrUtil.format((CharSequence)"\u89e3\u51b3\u65b9\u6848\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01{}\uff0c\u5f53\u524d\u7f16\u7801: {}", (Object[])new Object[]{"\u53ea\u80fd\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf", this.type}));
        }
    }

    public static boolean isAssemblyApp(Integer appType) {
        if (appType == null) {
            return false;
        }
        return appType >= 10000;
    }

    public void setPublishTime(LocalDateTime publishTime) {
        this.publishTime = publishTime;
    }

    @Override
    public void setPublishTime(Date publishTime) {
        this.setPublishTime(LocalDateTimeUtil.of((Date)publishTime));
    }

    @Override
    public Date getPublishTime() {
        if (this.publishTime == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = this.publishTime.atZone(zoneId);
        return Date.from(zonedDateTime.toInstant());
    }

    public static String getCategory(String category) {
        return (String)ObjUtil.defaultIfNull((Object)category, (Object)"6");
    }

    public String getCategory() {
        return SolutionPlan.getCategory(this.category);
    }

    @Generated
    public SolutionPlan() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public Integer getVersionSort() {
        return this.versionSort;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getAssemblyType() {
        return this.assemblyType;
    }

    @Override
    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public Integer getAppType() {
        return this.appType;
    }

    @Generated
    public List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> getDesignerList() {
        return this.designerList;
    }

    @Generated
    public Integer getFrontBizSetupPageIdx() {
        return this.frontBizSetupPageIdx;
    }

    @Generated
    public Map<String, Object> getCanvas() {
        return this.canvas;
    }

    @Generated
    public String getLayoutMode() {
        return this.layoutMode;
    }

    @Generated
    public SolutionPlanDetailDTO.SsoConfigDTO getSsoConfig() {
        return this.ssoConfig;
    }

    @Generated
    public List<SolutionPlanDetailDTO.AppCallBackDTO> getAppCreateCallback() {
        return this.appCreateCallback;
    }

    @Generated
    public List<SolutionPlanDetailDTO.AppCallBackDTO> getAppUpdateCallback() {
        return this.appUpdateCallback;
    }

    @Generated
    public List<SolutionPlanDetailDTO.AppCallBackDTO> getCompile() {
        return this.compile;
    }

    @Generated
    public List<SolutionPlanDetailDTO.AppCallBackDTO> getPublish() {
        return this.publish;
    }

    @Generated
    public Boolean getIsStdPublish() {
        return this.isStdPublish;
    }

    @Generated
    public Map<String, Object> getMergeJson() {
        return this.mergeJson;
    }

    @Generated
    public Map<String, MultiLanguageDTO<String>> getLang() {
        return this.lang;
    }

    @Generated
    public String getPublishBy() {
        return this.publishBy;
    }

    @Generated
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public LocalDateTime getEditTime() {
        return this.editTime;
    }

    @Generated
    public String getCreateBy() {
        return this.createBy;
    }

    @Generated
    public String getEditBy() {
        return this.editBy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setVersionSort(Integer versionSort) {
        this.versionSort = versionSort;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAssemblyType(String assemblyType) {
        this.assemblyType = assemblyType;
    }

    @Override
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    @Generated
    public void setDesignerList(List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> designerList) {
        this.designerList = designerList;
    }

    @Generated
    public void setFrontBizSetupPageIdx(Integer frontBizSetupPageIdx) {
        this.frontBizSetupPageIdx = frontBizSetupPageIdx;
    }

    @Generated
    public void setCanvas(Map<String, Object> canvas) {
        this.canvas = canvas;
    }

    @Generated
    public void setLayoutMode(String layoutMode) {
        this.layoutMode = layoutMode;
    }

    @Generated
    public void setSsoConfig(SolutionPlanDetailDTO.SsoConfigDTO ssoConfig) {
        this.ssoConfig = ssoConfig;
    }

    @Generated
    public void setAppCreateCallback(List<SolutionPlanDetailDTO.AppCallBackDTO> appCreateCallback) {
        this.appCreateCallback = appCreateCallback;
    }

    @Generated
    public void setAppUpdateCallback(List<SolutionPlanDetailDTO.AppCallBackDTO> appUpdateCallback) {
        this.appUpdateCallback = appUpdateCallback;
    }

    @Generated
    public void setCompile(List<SolutionPlanDetailDTO.AppCallBackDTO> compile) {
        this.compile = compile;
    }

    @Generated
    public void setPublish(List<SolutionPlanDetailDTO.AppCallBackDTO> publish) {
        this.publish = publish;
    }

    @Generated
    public void setIsStdPublish(Boolean isStdPublish) {
        this.isStdPublish = isStdPublish;
    }

    @Generated
    public void setMergeJson(Map<String, Object> mergeJson) {
        this.mergeJson = mergeJson;
    }

    @Generated
    public void setLang(Map<String, MultiLanguageDTO<String>> lang) {
        this.lang = lang;
    }

    @Generated
    public void setPublishBy(String publishBy) {
        this.publishBy = publishBy;
    }

    @Generated
    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setEditTime(LocalDateTime editTime) {
        this.editTime = editTime;
    }

    @Generated
    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @Generated
    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolutionPlan)) {
            return false;
        }
        SolutionPlan other = (SolutionPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$versionSort = this.getVersionSort();
        Integer other$versionSort = other.getVersionSort();
        if (this$versionSort == null ? other$versionSort != null : !((Object)this$versionSort).equals(other$versionSort)) {
            return false;
        }
        Integer this$appType = this.getAppType();
        Integer other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !((Object)this$appType).equals(other$appType)) {
            return false;
        }
        Integer this$frontBizSetupPageIdx = this.getFrontBizSetupPageIdx();
        Integer other$frontBizSetupPageIdx = other.getFrontBizSetupPageIdx();
        if (this$frontBizSetupPageIdx == null ? other$frontBizSetupPageIdx != null : !((Object)this$frontBizSetupPageIdx).equals(other$frontBizSetupPageIdx)) {
            return false;
        }
        Boolean this$isStdPublish = this.getIsStdPublish();
        Boolean other$isStdPublish = other.getIsStdPublish();
        if (this$isStdPublish == null ? other$isStdPublish != null : !((Object)this$isStdPublish).equals(other$isStdPublish)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$assemblyType = this.getAssemblyType();
        String other$assemblyType = other.getAssemblyType();
        if (this$assemblyType == null ? other$assemblyType != null : !this$assemblyType.equals(other$assemblyType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> this$designerList = this.getDesignerList();
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> other$designerList = other.getDesignerList();
        if (this$designerList == null ? other$designerList != null : !((Object)this$designerList).equals(other$designerList)) {
            return false;
        }
        Map<String, Object> this$canvas = this.getCanvas();
        Map<String, Object> other$canvas = other.getCanvas();
        if (this$canvas == null ? other$canvas != null : !((Object)this$canvas).equals(other$canvas)) {
            return false;
        }
        String this$layoutMode = this.getLayoutMode();
        String other$layoutMode = other.getLayoutMode();
        if (this$layoutMode == null ? other$layoutMode != null : !this$layoutMode.equals(other$layoutMode)) {
            return false;
        }
        SolutionPlanDetailDTO.SsoConfigDTO this$ssoConfig = this.getSsoConfig();
        SolutionPlanDetailDTO.SsoConfigDTO other$ssoConfig = other.getSsoConfig();
        if (this$ssoConfig == null ? other$ssoConfig != null : !((Object)this$ssoConfig).equals(other$ssoConfig)) {
            return false;
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> this$appCreateCallback = this.getAppCreateCallback();
        List<SolutionPlanDetailDTO.AppCallBackDTO> other$appCreateCallback = other.getAppCreateCallback();
        if (this$appCreateCallback == null ? other$appCreateCallback != null : !((Object)this$appCreateCallback).equals(other$appCreateCallback)) {
            return false;
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> this$appUpdateCallback = this.getAppUpdateCallback();
        List<SolutionPlanDetailDTO.AppCallBackDTO> other$appUpdateCallback = other.getAppUpdateCallback();
        if (this$appUpdateCallback == null ? other$appUpdateCallback != null : !((Object)this$appUpdateCallback).equals(other$appUpdateCallback)) {
            return false;
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> this$compile = this.getCompile();
        List<SolutionPlanDetailDTO.AppCallBackDTO> other$compile = other.getCompile();
        if (this$compile == null ? other$compile != null : !((Object)this$compile).equals(other$compile)) {
            return false;
        }
        List<SolutionPlanDetailDTO.AppCallBackDTO> this$publish = this.getPublish();
        List<SolutionPlanDetailDTO.AppCallBackDTO> other$publish = other.getPublish();
        if (this$publish == null ? other$publish != null : !((Object)this$publish).equals(other$publish)) {
            return false;
        }
        Map<String, Object> this$mergeJson = this.getMergeJson();
        Map<String, Object> other$mergeJson = other.getMergeJson();
        if (this$mergeJson == null ? other$mergeJson != null : !((Object)this$mergeJson).equals(other$mergeJson)) {
            return false;
        }
        Map<String, MultiLanguageDTO<String>> this$lang = this.getLang();
        Map<String, MultiLanguageDTO<String>> other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        String this$publishBy = this.getPublishBy();
        String other$publishBy = other.getPublishBy();
        if (this$publishBy == null ? other$publishBy != null : !this$publishBy.equals(other$publishBy)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$editTime = this.getEditTime();
        LocalDateTime other$editTime = other.getEditTime();
        if (this$editTime == null ? other$editTime != null : !((Object)this$editTime).equals(other$editTime)) {
            return false;
        }
        String this$createBy = this.getCreateBy();
        String other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !this$createBy.equals(other$createBy)) {
            return false;
        }
        String this$editBy = this.getEditBy();
        String other$editBy = other.getEditBy();
        return !(this$editBy == null ? other$editBy != null : !this$editBy.equals(other$editBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolutionPlan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $versionSort = this.getVersionSort();
        result = result * 59 + ($versionSort == null ? 43 : ((Object)$versionSort).hashCode());
        Integer $appType = this.getAppType();
        result = result * 59 + ($appType == null ? 43 : ((Object)$appType).hashCode());
        Integer $frontBizSetupPageIdx = this.getFrontBizSetupPageIdx();
        result = result * 59 + ($frontBizSetupPageIdx == null ? 43 : ((Object)$frontBizSetupPageIdx).hashCode());
        Boolean $isStdPublish = this.getIsStdPublish();
        result = result * 59 + ($isStdPublish == null ? 43 : ((Object)$isStdPublish).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $assemblyType = this.getAssemblyType();
        result = result * 59 + ($assemblyType == null ? 43 : $assemblyType.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List<SolutionPlanDetailDTO.DesignerBaseInfoDTO> $designerList = this.getDesignerList();
        result = result * 59 + ($designerList == null ? 43 : ((Object)$designerList).hashCode());
        Map<String, Object> $canvas = this.getCanvas();
        result = result * 59 + ($canvas == null ? 43 : ((Object)$canvas).hashCode());
        String $layoutMode = this.getLayoutMode();
        result = result * 59 + ($layoutMode == null ? 43 : $layoutMode.hashCode());
        SolutionPlanDetailDTO.SsoConfigDTO $ssoConfig = this.getSsoConfig();
        result = result * 59 + ($ssoConfig == null ? 43 : ((Object)$ssoConfig).hashCode());
        List<SolutionPlanDetailDTO.AppCallBackDTO> $appCreateCallback = this.getAppCreateCallback();
        result = result * 59 + ($appCreateCallback == null ? 43 : ((Object)$appCreateCallback).hashCode());
        List<SolutionPlanDetailDTO.AppCallBackDTO> $appUpdateCallback = this.getAppUpdateCallback();
        result = result * 59 + ($appUpdateCallback == null ? 43 : ((Object)$appUpdateCallback).hashCode());
        List<SolutionPlanDetailDTO.AppCallBackDTO> $compile = this.getCompile();
        result = result * 59 + ($compile == null ? 43 : ((Object)$compile).hashCode());
        List<SolutionPlanDetailDTO.AppCallBackDTO> $publish = this.getPublish();
        result = result * 59 + ($publish == null ? 43 : ((Object)$publish).hashCode());
        Map<String, Object> $mergeJson = this.getMergeJson();
        result = result * 59 + ($mergeJson == null ? 43 : ((Object)$mergeJson).hashCode());
        Map<String, MultiLanguageDTO<String>> $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        String $publishBy = this.getPublishBy();
        result = result * 59 + ($publishBy == null ? 43 : $publishBy.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $editTime = this.getEditTime();
        result = result * 59 + ($editTime == null ? 43 : ((Object)$editTime).hashCode());
        String $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : $createBy.hashCode());
        String $editBy = this.getEditBy();
        result = result * 59 + ($editBy == null ? 43 : $editBy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolutionPlan(id=" + this.getId() + ", type=" + this.getType() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", versionSort=" + this.getVersionSort() + ", description=" + this.getDescription() + ", assemblyType=" + this.getAssemblyType() + ", status=" + this.getStatus() + ", owner=" + this.getOwner() + ", category=" + this.getCategory() + ", appType=" + this.getAppType() + ", designerList=" + String.valueOf(this.getDesignerList()) + ", frontBizSetupPageIdx=" + this.getFrontBizSetupPageIdx() + ", canvas=" + String.valueOf(this.getCanvas()) + ", layoutMode=" + this.getLayoutMode() + ", ssoConfig=" + String.valueOf(this.getSsoConfig()) + ", appCreateCallback=" + String.valueOf(this.getAppCreateCallback()) + ", appUpdateCallback=" + String.valueOf(this.getAppUpdateCallback()) + ", compile=" + String.valueOf(this.getCompile()) + ", publish=" + String.valueOf(this.getPublish()) + ", isStdPublish=" + this.getIsStdPublish() + ", mergeJson=" + String.valueOf(this.getMergeJson()) + ", lang=" + String.valueOf(this.getLang()) + ", publishTime=" + String.valueOf(this.getPublishTime()) + ", publishBy=" + this.getPublishBy() + ", createTime=" + String.valueOf(this.getCreateTime()) + ", editTime=" + String.valueOf(this.getEditTime()) + ", createBy=" + this.getCreateBy() + ", editBy=" + this.getEditBy() + ")";
    }
}

