package com.digiwin.athena.datacollect.model;

import com.digiwin.athena.datacollect.context.CollectContext;
import lombok.Data;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

/**
 * 数据采集结果
 */
@Data
public class CollectResult {

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 采集是否成功
     */
    private boolean success;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    public static CollectResult buildSuccess(CollectContext context, LocalDateTime startTime) {
        LocalDateTime now = LocalDateTime.now();

        CollectResult result = new CollectResult();

        result.setSuccess(true);
        result.setAssetType(context.getAssetType().getType());
        result.setStartTime(startTime);
        result.setEndTime(now);

        return result;
    }

    public static CollectResult buildFailed(Exception e, CollectContext context, LocalDateTime startTime) {
        CollectResult result = new CollectResult();

        result.setSuccess(false);
        result.setAssetType(context.getAssetType().getType());
        result.setStartTime(startTime);
        result.setEndTime(LocalDateTime.now());

        result.setErrorMessage(e.getMessage());

        return result;
    }

    /**
     * 执行耗时（毫秒）
     */
    public long getDurationMs() {
        if (startTime != null && endTime != null) {
            return ChronoUnit.MILLIS.between(startTime, endTime);
        }
        return 0;
    }

}
