package com.digiwin.athena.dto.assembly.designer;

import com.digiwin.athena.common.dict.Dict;
import com.digiwin.athena.constants.enums.assembly.IntegrationType;
import com.digiwin.athena.dto.action.MultiLanguageDTO;
import com.digiwin.athena.dto.assembly.solution.SolutionPlanBaseDTO;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.util.List;
import java.util.Map;

/**
 * 设计器
 */
@Data
public class DesignerSaveDTO {

    /**
     * 主键ID
     */
    private String id;

    /**
     * 设计器编码，全局唯一
     */
    @NotBlank
    @Length(max = 30)
    private String type;

    /**
     * 设计器名称
     */
    @NotBlank
    @Length(max = 50)
    private String name;

    /**
     * 归属方
     */
    private String owner;
    /**
     * 版本号，service层暂时写死1.0
     */
    private String version;

    /**
     * 描述
     */
    @NotBlank
    @Length(max = 512)
    private String description;

    /**
     * 关联的资产类型
     */
    private DesignerDetailDTO.RelatedAssetTypeDTO relatedAssetType;

    /**
     * 关联解决方案
     */
    private List<SolutionPlanBaseDTO> relatedSolutionPlan;

    /**
     * API列表
     */
    private List<DesignerDetailDTO.ApiExecInfoDTO> apiList;

    /**
     * 集成方式：MF/microApp/Iframe
     *
     * @see IntegrationType#getCode()
     */
    @Dict(enumClass = IntegrationType.class)
    private String integrationType;

    /**
     * 集成配置
     */
    private DesignerDetailDTO.IntegrationConfigDTO integrationConfig;

    /**
     * 多语言配置
     */
    private Map<String, MultiLanguageDTO<String>> lang;


}
