package com.digiwin.athena.service.assembly.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dao.mongodao.assembly.PublishableContext;
import com.digiwin.athena.dao.mongodao.assembly.RDesignerMongoDao;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.service.assembly.DDesignerService;
import com.digiwin.athena.service.assembly.RDesignerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 运行时Designer列表服务实现
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RDesignerServiceImpl implements RDesignerService {

    private final RDesignerMongoDao rDesignerMongoDao;
    private DDesignerService dDesignerService;

    @Override
    public Pagination<DesignerListDTO> getOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageParam) {
        log.debug("分页查询在线状态的设计器列表");
        return rDesignerMongoDao.selectOnlineDesignerPage(pageParam);
    }

    @Override
    public List<Designer> getDesigners(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return Collections.emptyList();
        }
        List<Designer> designers = rDesignerMongoDao.selectByIds(ids);

        Designer.sort(designers);
        return designers;
    }

    @Override
    public Map<String, Designer> getDesignerMap(Collection<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyMap();
        }

        return CollUtil.toMap(getDesigners(ids),
                MapUtil.newHashMap(ids.size()), Designer::getId);
    }

    @Override
    public DesignerDetailDTO findDetailById(String id) {
        return PublishableContext.withRuntime(() -> dDesignerService.findDetailById(id));
    }

    @Override
    public List<DesignerListDTO> findPublishedList() {
        return dDesignerService.findPublishedList();
    }

    @Autowired
    @Lazy
    public void setDDesignerService(DDesignerService dDesignerService) {
        this.dDesignerService = dDesignerService;
    }
}
