package com.digiwin.athena.service.assetType.impl;

import com.digiwin.athena.dao.mongodao.assetType.RAssetTypeMongoDao;
import com.digiwin.athena.dto.assetType.AssetTypeResDto;
import com.digiwin.athena.mongodb.domain.assetType.AssetType;
import com.digiwin.athena.service.assetType.RAssetTypeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@Slf4j
public class RAssetTypeServiceImpl implements RAssetTypeService {

    @Autowired
    private RAssetTypeMongoDao rAssetTypeMongoDao;

    @Override
    public List<AssetTypeResDto> assetTypeMenu() {
        List<AssetType> assetTypeList = rAssetTypeMongoDao.selectByStatus(AssetType.STATUS_ONLINE);
        return assetTypeList.stream().map(a->AssetTypeResDto.create(a)).collect(Collectors.toList());
    }

    @Override
    public List<AssetTypeResDto> getAssetTypes(Collection<String> assetTypeIds) {
        if (CollectionUtils.isEmpty(assetTypeIds)){
            return new ArrayList<>();
        }
        List<AssetType> assetTypes = rAssetTypeMongoDao.selectByIds(assetTypeIds);
        return assetTypes.stream().map(a->AssetTypeResDto.create(a)).collect(Collectors.toList());
    }
}
