/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller.asset;

import com.digiwin.athena.auth.annotation.FuncAuth;
import com.digiwin.athena.domain.pagedesign.TenantInfo;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.asset.AssetBatchOpenReqDto;
import com.digiwin.athena.dto.asset.AssetCenterInfoResDto;
import com.digiwin.athena.dto.asset.AssetDetailResDto;
import com.digiwin.athena.dto.asset.AssetInfoResDto;
import com.digiwin.athena.dto.asset.AssetOpenReqDto;
import com.digiwin.athena.dto.asset.AssetPagination;
import com.digiwin.athena.dto.asset.AssetRelationAppInfoResDto;
import com.digiwin.athena.dto.asset.AssetReqDto;
import com.digiwin.athena.dto.asset.CreateAssetReqDto;
import com.digiwin.athena.dto.asset.DepAssetResDto;
import com.digiwin.athena.dto.asset.DependentAssetResDto;
import com.digiwin.athena.dto.asset.DesignerAssetListReqDto;
import com.digiwin.athena.dto.asset.UpdateAssetBasicInfoReqDto;
import com.digiwin.athena.dto.asset.UseAssetListReqDto;
import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.service.asset.AssetCenter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assetCenter"})
@Tag(name="\u8d44\u4ea7\u4e2d\u5fc3", description="a80fcf1b-8d00-4e23-be19-f0c0a88ded5d")
@Validated
public class AssetCenterController {
    @Autowired
    private AssetCenter assetCenter;

    @PostMapping(value={"/assetCenterList/{type}"})
    @Operation(summary="\u8d44\u4ea7\u4e2d\u5fc3\u5217\u8868", description="type=all|DTD,all\u67e5\u8be2\u6240\u6709")
    public ResultDto<AssetPagination<AssetCenterInfoResDto>> assetCenterList(@RequestBody PageReqCondition<String> pageReqCondition, @PathVariable String type) {
        AssetPagination<AssetCenterInfoResDto> res = null;
        res = "all".equals(type) ? this.assetCenter.getAssetCenterList(pageReqCondition, null) : this.assetCenter.getAssetCenterList(pageReqCondition, type);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/designer/getDesignerAssetList"})
    @Operation(summary="\u8bbe\u8ba1\u5668\u5185\u67e5\u8be2\u8d44\u4ea7\u5217\u8868")
    public ResultDto<AssetPagination<AssetDetailResDto>> getDesignerAssetList(@RequestBody PageReqCondition<DesignerAssetListReqDto> pageReqCondition) {
        DesignerAssetListReqDto condition = (DesignerAssetListReqDto)pageReqCondition.getCondition();
        Assert.isTrue((!CollectionUtils.isEmpty(condition.getTypes()) ? 1 : 0) != 0, (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssetPagination<AssetDetailResDto> res = this.assetCenter.designerAssetList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/getAssetMenuInfo"})
    public ResultDto<List<AssetDetailResDto>> getAssetMenuInfo(@RequestBody Asset.ManageContext manageContext) {
        List<AssetDetailResDto> res = this.assetCenter.getAssetMenuInfo(manageContext);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/saveAsset"})
    @Operation(summary="\u521b\u5efa\u4fdd\u5b58\u8d44\u4ea7", description="\u65b0\u589e\u548c\u4fdd\u5b58\uff0c\u4fdd\u5b58\u9700\u8981\u5c06assetId\u4f20\u9012\u8fc7\u6765")
    public ResultDto<AssetDetailResDto> designerSaveAsset(@RequestBody CreateAssetReqDto createAssetReqDto) {
        AssetDetailResDto assetDetailResDto = this.assetCenter.saveAsset(createAssetReqDto, null);
        return ResultDto.createSuccess((Object)assetDetailResDto);
    }

    @PostMapping(value={"/batchSaveAsset"})
    @Operation(summary="\u521b\u5efa\u4fdd\u5b58\u8d44\u4ea7", description="\u65b0\u589e\u548c\u4fdd\u5b58\uff0c\u4fdd\u5b58\u9700\u8981\u5c06assetId\u4f20\u9012\u8fc7\u6765")
    public ResultDto<Collection<String>> batchSaveAsset(@RequestBody List<CreateAssetReqDto> createAssetReqDtos) {
        Set<Object> assetIds = new HashSet();
        if (!CollectionUtils.isEmpty(createAssetReqDtos)) {
            assetIds = createAssetReqDtos.stream().map(a -> this.assetCenter.saveAsset((CreateAssetReqDto)a, null).getAssetId()).collect(Collectors.toSet());
        }
        return ResultDto.createSuccess(assetIds);
    }

    @PostMapping(value={"/designerDeleteAsset"})
    @Operation(summary="\u5220\u9664\u8d44\u4ea7")
    public ResultDto<Boolean> designerDeleteAsset(@RequestBody List<AssetReqDto> deleteAssetReqDtos) {
        for (AssetReqDto deleteAssetReqDto : deleteAssetReqDtos) {
            this.assetCenter.deleteAsset(deleteAssetReqDto);
        }
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/deleteAsset"})
    @Operation(summary="\u5220\u9664\u8d44\u4ea7")
    public ResultDto<Boolean> deleteAsset(@RequestBody List<AssetReqDto> deleteAssetReqDtos) {
        this.assetCenter.deleteAsset(deleteAssetReqDtos);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/updateAssetBasicInfo"})
    public ResultDto<Boolean> updateAssetBasicInfo(@RequestBody @Validated UpdateAssetBasicInfoReqDto updateAssetBasicInfoReqDto) {
        this.assetCenter.updateAssetBasicInfo(updateAssetBasicInfoReqDto);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/assetDetailV2"})
    @Operation(summary="\u8d44\u4ea7\u8be6\u60c5")
    public ResultDto<AssetDetailResDto> assetDetailV2(@RequestBody AssetReqDto assetReqDto) {
        AssetDetailResDto res = this.assetCenter.assetDetailV2(assetReqDto);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/assetDetail"})
    @Operation(summary="\u8d44\u4ea7\u8be6\u60c5")
    @Deprecated
    public ResultDto<AssetDetailResDto> dtdAssetDetail(@Schema(description="\u8d44\u4ea7id") String assetId) {
        AssetDetailResDto res = this.assetCenter.getAsset(assetId);
        return ResultDto.createSuccess((Object)res);
    }

    @GetMapping(value={"/assetVersionList"})
    @Operation(summary="\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u6240\u6709\u7248\u672c\u4fe1\u606f")
    public ResultDto<List<AssetInfoResDto>> dtdAssetVersionList(@Schema(description="\u8d44\u4ea7id") String assetId) {
        List<AssetInfoResDto> res = this.assetCenter.assetVersionList(assetId);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/application/removedAsset"})
    @Operation(summary="\u4e0b\u67b6\u8d44\u4ea7")
    @FuncAuth(resourceType="application", resourceId="1", actions={":*"})
    public ResultDto<Boolean> removedAsset(@NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") String assetId, @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") String appCode) {
        return ResultDto.createSuccess((Object)this.assetCenter.removedAsset(assetId));
    }

    @GetMapping(value={"/removedAssetOpenTenant"})
    @Operation(summary="\u4e0b\u67b6\u8d44\u4ea7\u5f00\u53d1\u8303\u56f4\u7684\u6307\u5b9a\u79df\u6237")
    @FuncAuth(resourceType="result", resourceId="Var:$tenantId", actions={":*"})
    public ResultDto<Boolean> removedAssetOpenTenant(String assetId) {
        return ResultDto.createSuccess((Object)this.assetCenter.removedAssetOpenTenant(assetId));
    }

    @GetMapping(value={"/assetRelationAppInfo"})
    @Operation(summary="\u8d44\u4ea7\u5f53\u524d\u5f15\u7528\u4fe1\u606f")
    public ResultDto<List<AssetRelationAppInfoResDto>> assetRelationAppInfo(@Schema(description="\u8d44\u4ea7id") String assetId, @Schema(description="\u662f\u5426\u5728\u8d44\u4ea7\u4e2d\u5fc3") Boolean isAssetCenter) {
        List<AssetRelationAppInfoResDto> res = this.assetCenter.getAssetRefRelation(assetId, isAssetCenter);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/application/assetErrorCount"})
    @Operation(summary="\u5e94\u7528\u5185\u4f9d\u8d56\u5f00\u653e\u5f02\u5e38\u6570")
    public ResultDto<Integer> assetErrorCount(String appCode) {
        return ResultDto.createSuccess((Object)this.assetCenter.assetErrorCount(appCode));
    }

    @PostMapping(value={"/application/assetList/{appCode}/{type}"})
    @Operation(summary="\u5e94\u7528\u5185\u8d44\u4ea7\u5217\u8868", description="type=all|DTD,all\u67e5\u8be2\u6240\u6709")
    public ResultDto<Pagination<AssetCenterInfoResDto>> appAssetList(@RequestBody PageReqCondition<String> pageReqCondition, @PathVariable String appCode, @PathVariable String type) {
        Pagination<AssetCenterInfoResDto> res = null;
        res = "all".equals(type) ? this.assetCenter.appAssetList(pageReqCondition, List.of(appCode), List.of()) : this.assetCenter.appAssetList(pageReqCondition, List.of(appCode), List.of(type));
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/application/updateAssetDetail"})
    @Operation(summary="\u5e94\u7528\u5185\u66f4\u65b0\u8d44\u4ea7\u8be6\u60c5")
    @FuncAuth(resourceType="application", resourceId="Json:0#$.application", actions={":*"})
    public ResultDto<Boolean> updateAssetDetail(@Validated @RequestBody AssetOpenReqDto assetOpenReqDto) {
        if ("tenant".equals(assetOpenReqDto.getOpenRange())) {
            List<TenantInfo> tenantInfos = assetOpenReqDto.getTenantInfos();
            Assert.isTrue((tenantInfos.size() > 0 ? 1 : 0) != 0, (String)"\u9700\u8981\u6307\u5b9a\u5f00\u53d1\u7684\u79df\u6237\u5217\u8868");
            for (TenantInfo tenantInfo : tenantInfos) {
                if (!StringUtils.isEmpty((CharSequence)tenantInfo.getTenantId()) || !StringUtils.isEmpty((CharSequence)tenantInfo.getTenantName())) continue;
                throw new RuntimeException("\u5f00\u653e\u6307\u5b9a\u7684\u79df\u6237id \u79df\u6237\u540d\u79f0\u5fc5\u586b");
            }
        }
        return ResultDto.createSuccess((Object)this.assetCenter.updateAssetDefinition(assetOpenReqDto));
    }

    @PostMapping(value={"/application/availableAsset"})
    @Operation(summary="\u5e94\u7528\u5185\u4e0a\u67b6\u8d44\u4ea7")
    @FuncAuth(resourceType="application", resourceId="Json:0#$.application", actions={":*"})
    public ResultDto<Boolean> availableAsset(@Validated @RequestBody AssetOpenReqDto assetOpenReqDto) {
        return ResultDto.createSuccess((Object)this.assetCenter.availableAsset(assetOpenReqDto));
    }

    @PostMapping(value={"/application/batchAvailableAsset"})
    @Operation(summary="\u5e94\u7528\u5185\u6279\u91cf\u4e0a\u67b6\u8d44\u4ea7")
    @FuncAuth(resourceType="application", resourceId="Json:0#$.application", actions={":*"})
    public ResultDto<Boolean> batchAvailableAsset(@Validated @RequestBody AssetBatchOpenReqDto assetBatchOpenReqDto) {
        return ResultDto.createSuccess((Object)this.assetCenter.batchAvailableAsset(assetBatchOpenReqDto));
    }

    @GetMapping(value={"/application/assetInit"})
    @Operation(summary="\u5e94\u7528\u5185\u8d44\u4ea7\u521d\u59cb\u5316", description="type|ALL-\u521d\u59cb\u5316\u5168\u90e8\uff0cDTD-\u521d\u59cb\u5316DTD")
    @FuncAuth(resourceType="application", resourceId="0", actions={":*"})
    public ResultDto<Boolean> dtdAssetInit(@NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a") String appCode, @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") String type) {
        this.assetCenter.assetInit(appCode, type);
        return ResultDto.createSuccess((Object)true);
    }

    @PostMapping(value={"/application/dependentAssetsInfo/{appCode}/{type}"})
    @Operation(summary="\u4f9d\u8d56\u5f15\u7528\u7684\u8d44\u4ea7\u4fe1\u606f\u5217\u8868", description="type=all|DTD,all\u67e5\u8be2\u6240\u6709")
    public ResultDto<Pagination<DependentAssetResDto>> dependentAssetsInfo(@RequestBody PageReqCondition<String> pageReqCondition, @PathVariable String appCode, @PathVariable String type) {
        Pagination<DependentAssetResDto> res = this.assetCenter.getDependAssetInfoList(pageReqCondition, appCode, "all".equals(type) ? null : type);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/application/dtdAssetAvailableList/{tabCategory}"})
    @Operation(summary="dtd\u4f7f\u7528\u5217\u8868", description="tabCategory:team-\u56e2\u961f|platform-\u5e73\u53f0")
    public ResultDto<Pagination<AssetDetailResDto>> dtdAssetAvailableList(@RequestBody PageReqCondition<String> pageReqCondition, @PathVariable String tabCategory) {
        Pagination<AssetDetailResDto> res = "team".equals(tabCategory) ? this.assetCenter.getSameTenantDtdAsset(pageReqCondition) : this.assetCenter.getPlatformDtdAsset(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @PostMapping(value={"/application/batchSyncAsset"})
    @Operation(summary="\u6279\u91cf\u66f4\u65b0\u8d44\u4ea7\u6570\u636e")
    public ResultDto<Boolean> batchSyncAsset(@RequestBody List<String> assetIds) {
        if (CollectionUtils.isEmpty(assetIds)) {
            throw new RuntimeException("\u9009\u4e2d\u8d44\u4ea7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResultDto.createSuccess((Object)this.assetCenter.batchSyncAsset(assetIds));
    }

    @PostMapping(value={"/application/appUseAssetList"})
    @Operation(summary="\u5e94\u7528\u5185\u4f7f\u7528\u8d44\u4ea7\u5217\u8868")
    public ResultDto<Pagination<AssetCenterInfoResDto>> appUseAssetList(@RequestBody PageReqCondition<UseAssetListReqDto> pageReqCondition) {
        Pagination<AssetCenterInfoResDto> res = this.assetCenter.appUseAssetList(pageReqCondition);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/application/unbindingRelationship"})
    @FuncAuth(resourceType="application", resourceId="2", actions={":*"})
    @Operation(summary="\u89e3\u7ed1\u5f15\u7528\u5173\u7cfb", description="type=DTD")
    public ResultDto<Boolean> unbindingRelationship(@NotEmpty(message="taskCode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="taskCode\u4e0d\u80fd\u4e3a\u7a7a") String taskCodes, @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") String type, @NotEmpty(message="appCode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="appCode\u4e0d\u80fd\u4e3a\u7a7a") String appCode) {
        this.assetCenter.unbindingRelationship(taskCodes, type, appCode);
        return ResultDto.createSuccess((Object)true);
    }

    @GetMapping(value={"/assetCanCopyVersionList"})
    @Operation(summary="\u67e5\u8be2\u6307\u5b9a\u8d44\u4ea7\u53ef\u590d\u5236\u7248\u672c\u4fe1\u606f")
    public ResultDto<List<AssetInfoResDto>> assetCanCopyVersionList(@Schema(description="\u8d44\u4ea7id") @NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") String assetId) {
        List<AssetInfoResDto> res = this.assetCenter.assetCanCopyVersionList(assetId);
        return ResultDto.createSuccess(res);
    }

    @GetMapping(value={"/getAssetDefinitionInfo"})
    @Operation(summary="\u6839\u636e\u4e1a\u52a1code\u67e5\u8be2\u8d44\u4ea7\u4fe1\u606f", description="type=DTD")
    public ResultDto<AssetCenterInfoResDto> getAssetDefinitionInfo(@NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="type\u4e0d\u80fd\u4e3a\u7a7a") String type) {
        return ResultDto.createSuccess((Object)this.assetCenter.getAssetDefinitionInfo(code, type));
    }

    @GetMapping(value={"/getDepAssets"})
    public ResultDto<List<DepAssetResDto>> getDepAssets(@NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u8d44\u4ea7id\u4e0d\u80fd\u4e3a\u7a7a") String objId) {
        List<DepAssetResDto> res = this.assetCenter.getDepAssets(objId);
        return ResultDto.createSuccess(res);
    }
}

