package com.digiwin.athena.config;

import com.digiwin.athena.service.asset.AssetBusinessDataAction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AssetCenterRegisterConfig implements InitializingBean {
    @Autowired
    private List<AssetBusinessDataAction> assetBusinessDataActionList;
    private Map<String,AssetBusinessDataAction> assetBusinessDataActions = new HashMap<>();

    public Map<String, AssetBusinessDataAction> getAssetBusinessDataActions() {
        return assetBusinessDataActions;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        for (AssetBusinessDataAction action : assetBusinessDataActionList) {
            String code = action.getAssetType().getCode();
            assetBusinessDataActions.put(code, action);
        }
    }
}
