package com.digiwin.athena.constants.enums.assembly;

import com.digiwin.athena.constants.enums.BaseLangEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 集成方式枚举
 */
@Getter
@AllArgsConstructor
public enum IntegrationType implements BaseLangEnum<String> {
    /**
     * Iframe集成
     */
    Iframe("Iframe", "Iframe集成", "Iframe集成", "Iframe"),
    /**
     * 微前端集成
     */
    MicroApp("MicroApp", "微前端集成", "微前端集成", "MicroApp"),
    /**
     * 模块联邦集成
     */
    ModuleFederation("MF", "模块联邦集成", "模組聯邦集成", "Module Federation");

    private final String code;
    private final String descZhCn;
    private final String descZhTw;
    private final String descEnUs;
}
