package com.digiwin.athena.controller.assembly;

import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;
import com.digiwin.athena.service.assembly.RDesignerService;
import jakarta.validation.constraints.NotBlank;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 设计器运行时
 */
@Slf4j
@RestController
@RequestMapping("/assembly/designer/r/")
@RequiredArgsConstructor
public class RDesignerController {

    private final RDesignerService rDesignerService;

    /**
     * 列表
     */
    @PostMapping("/list")
    public ResultDto<Pagination<DesignerListDTO>> getOnlineDesignerList(@RequestBody PageReqCondition<RDesignerPageQo> pageReqCondition) {
        log.debug("收到分页查询在线状态设计器列表请求");
        Pagination<DesignerListDTO> result = rDesignerService.getOnlineDesignerPage(pageReqCondition);
        return ResultDto.createSuccess(result);
    }


    /**
     * 详情
     */
    @GetMapping("/{id}")
    public ResultDto<DesignerDetailDTO> getDesignTimeDesignerDetail(@NotBlank @PathVariable String id) {
        log.debug("收到获取运行时态设计器详情请求: {}", id);
        return ResultDto.createSuccess(rDesignerService.findDetailById(id));
    }

    /**
     * 获取已发布的设计器列表（上架/下架状态）
     */
    @GetMapping("/list/published")
    public ResultDto<List<DesignerListDTO>> listPublished() {
        log.debug("收到获取已发布设计器列表请求");

        List<DesignerListDTO> res = rDesignerService.findPublishedList();

        return ResultDto.createSuccess(res);
    }
}
