package com.digiwin.athena.convertor.assembly;

import com.digiwin.athena.convertor.BaseConverter;
import com.digiwin.athena.datacollect.context.CollectContext;
import com.digiwin.athena.datacollect.model.JobExecData;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

@Mapper(uses = {BaseConverter.class})
public interface DataCollectorConverter {
    DataCollectorConverter INSTANCE = Mappers.getMapper(DataCollectorConverter.class);

    @Mapping(source = "stepStartTime", target = "currentStepStartTime")
    @Mapping(source = "stepEndTime", target = "currentStepEndTime")
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void merge(JobExecData presetExecData, @MappingTarget CollectContext context);
}
