package com.digiwin.athena.dao.mongodao.assembly;

import com.digiwin.athena.bo.assembly.Designer;
import com.digiwin.athena.dto.PageReqCondition;
import com.digiwin.athena.dto.Pagination;
import com.digiwin.athena.dto.assembly.designer.DesignerDetailDTO;
import com.digiwin.athena.dto.assembly.designer.DesignerListDTO;
import com.digiwin.athena.dto.assembly.designer.RDesignerPageQo;

import java.util.Collection;
import java.util.List;

/**
 * 运行时态设计器DAO接口
 */
public interface RDesignerMongoDao {

    /**
     * 根据ID查询设计器
     *
     * @param objectId 对象ID
     * @return 设计器信息
     */
    Designer selectById(String objectId);

    /**
     * 分页查询状态为online的设计器列表
     *
     * @param pageReqCondition 分页查询条件
     * @return 分页结果
     */
    Pagination<DesignerListDTO> selectOnlineDesignerPage(PageReqCondition<RDesignerPageQo> pageReqCondition);

    /**
     * 新增设计器
     *
     * @param designer 设计器信息
     * @return 设计器信息
     */
    void save(Designer designer);

    /**
     * 根据ID删除设计器
     *
     * @param objectId 对象ID
     * @return 是否成功
     */
    boolean deleteById(String objectId);

    List<Designer> selectByIds(Collection<String> ids);
}
