package com.digiwin.athena.dao.mongodao.asset;

import com.digiwin.athena.mongodb.domain.application.Asset;
import com.digiwin.athena.mongodb.domain.application.AssetDefinition;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
@RequiredArgsConstructor
@Deprecated
public class RAssetMongoDao {

    private final MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void insertAll(List<Asset> assetList) {
        mongoRuntimeRepositoryDecorator.insertAll(assetList);
    }

    public void deleteByObjIds(List<String> objIds) {
        mongoRuntimeRepositoryDecorator.delete(new Query(Criteria.where("_id").in(objIds)), Asset.class);
    }

    public void deleteByApplication(String appCode) {
        mongoRuntimeRepositoryDecorator.delete(new Query(Criteria.where("manageContext.application").is(appCode)), Asset.class);
    }
}
