package com.digiwin.athena.datacollect.api.dto;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.datacollect.context.CollectContext;
import lombok.Data;

import java.util.Map;


/**
 * 资产实例数据采集API请求参数
 * 对应平台标准HTTP接口规范
 */
@Data
public class AssetCollectApiRequest {

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 分页参数 - 页码
     */
    private Integer pageNo;

    /**
     * 分页参数 - 每页大小
     */
    private Integer pageSize;

    /**
     * 指定数据变更的类型
     * 可选: insert/update/delete/upsert
     */
    private String op;


    /**
     * 构建请求参数（使用Context中的参数）
     */
    public static Map<String, Object> buildRequestMap(CollectContext context) {
        AssetCollectApiRequest request = new AssetCollectApiRequest();

        // 基本参数
        request.setAssetType(context.getAssetType().getType());
        request.setPageNo(context.getPageNo());
        request.setPageSize(context.getPageSize());

        // 时间范围（使用步进时间）
        if (context.getCurrentStepStartTime() != null) {
            request.setStartTime(DateUtil.formatLocalDateTime(context.getCurrentStepStartTime()));
        }
        if (context.getCurrentStepEndTime() != null) {
            request.setEndTime(DateUtil.formatLocalDateTime(context.getCurrentStepEndTime()));
        }


        Map<String, Object> map = BeanUtil.beanToMap(request);
        // loopParam参数
        if (context.getLoopParam() != null && !context.getLoopParam().isEmpty()) {
            map.putAll(context.getLoopParam());
        }
        return map;
    }

}
