package com.digiwin.athena.datacollect.model;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务下次执行数据
 * 保存上次执行的Context信息，支持续查
 */
@Data
public class JobExecData {

    /**
     * 上次采集时间
     * 成功时为本次查询的endTime，失败时为当前时间
     */
    private LocalDateTime lastCollectTime;

    /**
     * 查询开始时间
     * 用于续查
     */
    private LocalDateTime startTime;

    /**
     * 查询结束时间
     * 用于续查
     */
    private LocalDateTime endTime;

    /**
     * 页码
     * 用于续查，从断点页继续
     */
    private Integer pageNo;

    /**
     * 循环索引
     * 用于续查，从断点循环继续
     */
    private Integer loopIndex;

    /**
     * 步骤开始时间
     * 用于步进式查询续查
     */
    private LocalDateTime stepStartTime;

    /**
     * 步骤结束时间
     * 用于步进式查询续查
     */
    private LocalDateTime stepEndTime;
}
