package com.digiwin.athena.dto.assembly.application;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import java.util.Map;

/**
 * 应用数据保存请求DTO
 */
@Data
@Schema(description = "应用数据保存请求")
public class ApplicationDataSaveDTO {

    @NotBlank(message = "应用编码不能为空")
    @Schema(description = "应用编码")
    private String appCode;

    @Schema(description = "解决方案数据")
    private Map<String, Object> data;
}
